package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.*;
import jakarta.ws.rs.core.GenericType;

/** RoomContactTypesApi class. */
public class RoomContactTypesApi {
  private ApiClient apiClient;

  /** RoomContactTypesApi. */
  public RoomContactTypesApi() {
    this(Configuration.getDefaultApiClient());
  }

  /** RoomContactTypesApi. */
  public RoomContactTypesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * getApiClient Method.
   *
   * @return ApiClient
   */
  public ApiClient getApiClient() {
    return apiClient;
  }

  /** setApiClient Method. */
  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Retrieves the list of valid room contact types.. Returns a list of room contact types, such as
   * Buyer, Seller, and Listing Agent.
   *
   * @return GlobalRoomContactTypes
   * @throws ApiException if fails to make API call
   */
  public GlobalRoomContactTypes getRoomContactTypes() throws ApiException {
    ApiResponse<GlobalRoomContactTypes> localVarResponse = getRoomContactTypesWithHttpInfo();
    return localVarResponse.getData();
  }

  /**
   * Retrieves the list of valid room contact types. Returns a list of room contact types, such as
   * Buyer, Seller, and Listing Agent.
   *
   * @return GlobalRoomContactTypes
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<GlobalRoomContactTypes> getRoomContactTypesWithHttpInfo() throws ApiException {
    Object localVarPostBody = "{}";

    // create path and map variables
    String localVarPath = "/v2/room_contact_types";

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {
      "text/plain", "application/json", "text/json", "application/xml", "text/xml"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json-patch+json", "application/json", "text/json", "application/_*+json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<GlobalRoomContactTypes> localVarReturnType =
        new GenericType<GlobalRoomContactTypes>() {};
    GlobalRoomContactTypes localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<GlobalRoomContactTypes>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }
}
