/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.AssignableRoles;
import com.docusign.rooms.model.Document;
import com.docusign.rooms.model.FieldData;
import com.docusign.rooms.model.FieldDataForUpdate;
import com.docusign.rooms.model.FieldSet;
import com.docusign.rooms.model.FormForAdd;
import com.docusign.rooms.model.Room;
import com.docusign.rooms.model.RoomDocument;
import com.docusign.rooms.model.RoomDocumentList;
import com.docusign.rooms.model.RoomForCreate;
import com.docusign.rooms.model.RoomInvite;
import com.docusign.rooms.model.RoomInviteResponse;
import com.docusign.rooms.model.RoomPicture;
import com.docusign.rooms.model.RoomSummaryList;
import com.docusign.rooms.model.RoomUser;
import com.docusign.rooms.model.RoomUserForUpdate;
import com.docusign.rooms.model.RoomUserRemovalDetail;
import com.docusign.rooms.model.RoomUsersResult;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class RoomsApi {
    private ApiClient apiClient;

    public RoomsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoomsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RoomDocument addDocumentToRoom(String accountId, Integer roomId, Document body) throws ApiException {
        Document localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addDocumentToRoom");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling addDocumentToRoom");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomDocument> localVarReturnType = new GenericType<RoomDocument>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoomDocument addDocumentToRoomViaFileUpload(String accountId, Integer roomId, byte[] file) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addDocumentToRoomViaFileUpload");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling addDocumentToRoomViaFileUpload");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/documents/contents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomDocument> localVarReturnType = new GenericType<RoomDocument>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoomDocument addFormToRoom(String accountId, Integer roomId, FormForAdd body) throws ApiException {
        FormForAdd localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addFormToRoom");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling addFormToRoom");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/forms".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomDocument> localVarReturnType = new GenericType<RoomDocument>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Room createRoom(String accountId, RoomForCreate body) throws ApiException {
        RoomForCreate localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createRoom");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Room> localVarReturnType = new GenericType<Room>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteRoom(String accountId, Integer roomId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteRoom");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling deleteRoom");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public AssignableRoles getAssignableRoles(String accountId, Integer roomId) throws ApiException {
        return this.getAssignableRoles(accountId, roomId, null);
    }

    public AssignableRoles getAssignableRoles(String accountId, Integer roomId, GetAssignableRolesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAssignableRoles");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling getAssignableRoles");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/assignable_roles".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("assigneeEmail", options.assigneeEmail));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", options.filter));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<AssignableRoles> localVarReturnType = new GenericType<AssignableRoles>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoomDocumentList getDocuments(String accountId, Integer roomId) throws ApiException {
        return this.getDocuments(accountId, roomId, null);
    }

    public RoomDocumentList getDocuments(String accountId, Integer roomId, GetDocumentsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDocuments");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling getDocuments");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/documents".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomDocumentList> localVarReturnType = new GenericType<RoomDocumentList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Room getRoom(String accountId, Integer roomId) throws ApiException {
        return this.getRoom(accountId, roomId, null);
    }

    public Room getRoom(String accountId, Integer roomId, GetRoomOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRoom");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling getRoom");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeFieldData", options.includeFieldData));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Room> localVarReturnType = new GenericType<Room>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FieldData getRoomFieldData(String accountId, Integer roomId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRoomFieldData");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling getRoomFieldData");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/field_data".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FieldData> localVarReturnType = new GenericType<FieldData>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FieldSet getRoomFieldSet(String accountId, Integer roomId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRoomFieldSet");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling getRoomFieldSet");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/field_set".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FieldSet> localVarReturnType = new GenericType<FieldSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoomUsersResult getRoomUsers(String accountId, Integer roomId) throws ApiException {
        return this.getRoomUsers(accountId, roomId, null);
    }

    public RoomUsersResult getRoomUsers(String accountId, Integer roomId, GetRoomUsersOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRoomUsers");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling getRoomUsers");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", options.filter));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", options.sort));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomUsersResult> localVarReturnType = new GenericType<RoomUsersResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoomSummaryList getRooms(String accountId) throws ApiException {
        return this.getRooms(accountId, null);
    }

    public RoomSummaryList getRooms(String accountId, GetRoomsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRooms");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("roomStatus", options.roomStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("officeId", options.officeId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldDataChangedStartDate", options.fieldDataChangedStartDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fieldDataChangedEndDate", options.fieldDataChangedEndDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("roomClosedStartDate", options.roomClosedStartDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("roomClosedEndDate", options.roomClosedEndDate));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomSummaryList> localVarReturnType = new GenericType<RoomSummaryList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoomInviteResponse inviteUser(String accountId, Integer roomId, RoomInvite body) throws ApiException {
        RoomInvite localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling inviteUser");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling inviteUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomInviteResponse> localVarReturnType = new GenericType<RoomInviteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoomUser putRoomUser(String accountId, Integer roomId, Integer userId, RoomUserForUpdate body) throws ApiException {
        RoomUserForUpdate localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling putRoomUser");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling putRoomUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling putRoomUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/users/{userId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomUser> localVarReturnType = new GenericType<RoomUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void restoreRoomUserAccess(String accountId, Integer roomId, Integer userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling restoreRoomUserAccess");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling restoreRoomUserAccess");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling restoreRoomUserAccess");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/users/{userId}/restore_access".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void revokeRoomUserAccess(String accountId, Integer roomId, Integer userId, RoomUserRemovalDetail body) throws ApiException {
        RoomUserRemovalDetail localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling revokeRoomUserAccess");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling revokeRoomUserAccess");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling revokeRoomUserAccess");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/users/{userId}/revoke_access".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public RoomPicture updatePicture(String accountId, Integer roomId, byte[] file) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updatePicture");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling updatePicture");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/picture".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomPicture> localVarReturnType = new GenericType<RoomPicture>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FieldData updateRoomFieldData(String accountId, Integer roomId, FieldDataForUpdate body) throws ApiException {
        FieldDataForUpdate localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateRoomFieldData");
        }
        if (roomId == null) {
            throw new ApiException(400, "Missing the required parameter 'roomId' when calling updateRoomFieldData");
        }
        String localVarPath = "/v2/accounts/{accountId}/rooms/{roomId}/field_data".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{roomId\\}", this.apiClient.escapeString(roomId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FieldData> localVarReturnType = new GenericType<FieldData>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetRoomsOptions {
        private Integer count = null;
        private Integer startPosition = null;
        private String roomStatus = null;
        private Integer officeId = null;
        private String fieldDataChangedStartDate = null;
        private String fieldDataChangedEndDate = null;
        private String roomClosedStartDate = null;
        private String roomClosedEndDate = null;

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }

        public void setRoomStatus(String roomStatus) {
            this.roomStatus = roomStatus;
        }

        public String getRoomStatus() {
            return this.roomStatus;
        }

        public void setOfficeId(Integer officeId) {
            this.officeId = officeId;
        }

        public Integer getOfficeId() {
            return this.officeId;
        }

        public void setFieldDataChangedStartDate(String fieldDataChangedStartDate) {
            this.fieldDataChangedStartDate = fieldDataChangedStartDate;
        }

        public String getFieldDataChangedStartDate() {
            return this.fieldDataChangedStartDate;
        }

        public void setFieldDataChangedEndDate(String fieldDataChangedEndDate) {
            this.fieldDataChangedEndDate = fieldDataChangedEndDate;
        }

        public String getFieldDataChangedEndDate() {
            return this.fieldDataChangedEndDate;
        }

        public void setRoomClosedStartDate(String roomClosedStartDate) {
            this.roomClosedStartDate = roomClosedStartDate;
        }

        public String getRoomClosedStartDate() {
            return this.roomClosedStartDate;
        }

        public void setRoomClosedEndDate(String roomClosedEndDate) {
            this.roomClosedEndDate = roomClosedEndDate;
        }

        public String getRoomClosedEndDate() {
            return this.roomClosedEndDate;
        }
    }

    public class GetRoomUsersOptions {
        private Integer count = null;
        private Integer startPosition = null;
        private String filter = null;
        private String sort = null;

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public String getSort() {
            return this.sort;
        }
    }

    public class GetRoomOptions {
        private Boolean includeFieldData = null;

        public void setIncludeFieldData(Boolean includeFieldData) {
            this.includeFieldData = includeFieldData;
        }

        public Boolean getIncludeFieldData() {
            return this.includeFieldData;
        }
    }

    public class GetDocumentsOptions {
        private Integer count = null;
        private Integer startPosition = null;

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetAssignableRolesOptions {
        private String assigneeEmail = null;
        private String filter = null;
        private Integer startPosition = null;
        private Integer count = null;

        public void setAssigneeEmail(String assigneeEmail) {
            this.assigneeEmail = assigneeEmail;
        }

        public String getAssigneeEmail() {
            return this.assigneeEmail;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }
    }
}

