/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.FieldSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class FieldsApi {
    private ApiClient apiClient;

    public FieldsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FieldsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FieldSet getFieldSet(String accountId, UUID fieldSetId) throws ApiException {
        return this.getFieldSet(accountId, fieldSetId, null);
    }

    public FieldSet getFieldSet(String accountId, UUID fieldSetId, GetFieldSetOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFieldSet");
        }
        if (fieldSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'fieldSetId' when calling getFieldSet");
        }
        String localVarPath = "/v2/accounts/{accountId}/field_sets/{fieldSetId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{fieldSetId\\}", this.apiClient.escapeString(fieldSetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "fieldsCustomDataFilters", options.fieldsCustomDataFilters));
        }
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<FieldSet> localVarReturnType = new GenericType<FieldSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetFieldSetOptions {
        private List<String> fieldsCustomDataFilters = null;

        public void setFieldsCustomDataFilters(List<String> fieldsCustomDataFilters) {
            this.fieldsCustomDataFilters = fieldsCustomDataFilters;
        }

        public List<String> getFieldsCustomDataFilters() {
            return this.fieldsCustomDataFilters;
        }
    }
}

