/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.ClassicAdminToInvite;
import com.docusign.rooms.model.ClassicAgentToInvite;
import com.docusign.rooms.model.ClassicManagerToInvite;
import com.docusign.rooms.model.DesignatedOffice;
import com.docusign.rooms.model.DesignatedRegion;
import com.docusign.rooms.model.LockedOutDetails;
import com.docusign.rooms.model.User;
import com.docusign.rooms.model.UserForUpdate;
import com.docusign.rooms.model.UserSummaryList;
import com.docusign.rooms.model.UserToInvite;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void addUserToOffice(String accountId, Integer userId, DesignatedOffice designatedOffice) throws ApiException {
        DesignatedOffice localVarPostBody = designatedOffice;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling addUserToOffice");
        }
        if (designatedOffice == null) {
            throw new ApiException(400, "Missing the required parameter 'designatedOffice' when calling addUserToOffice");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addUserToOffice");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/add_to_office".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void addUserToRegion(String accountId, Integer userId, DesignatedRegion designatedRegion) throws ApiException {
        DesignatedRegion localVarPostBody = designatedRegion;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling addUserToRegion");
        }
        if (designatedRegion == null) {
            throw new ApiException(400, "Missing the required parameter 'designatedRegion' when calling addUserToRegion");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addUserToRegion");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/add_to_region".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public User getUser(String accountId, Integer userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserSummaryList getUsers(String accountId) throws ApiException {
        return this.getUsers(accountId, null);
    }

    public UserSummaryList getUsers(String accountId, GetUsersOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getUsers");
        }
        String localVarPath = "/v2/accounts/{accountId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", options.filter));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", options.sort));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("defaultOfficeId", options.defaultOfficeId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("accessLevel", options.accessLevel));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("titleId", options.titleId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("roleId", options.roleId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("lockedOnly", options.lockedOnly));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSummaryList> localVarReturnType = new GenericType<UserSummaryList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public User inviteClassicAdmin(String accountId, ClassicAdminToInvite invitee) throws ApiException {
        ClassicAdminToInvite localVarPostBody = invitee;
        if (invitee == null) {
            throw new ApiException(400, "Missing the required parameter 'invitee' when calling inviteClassicAdmin");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling inviteClassicAdmin");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/invite_classic_admin".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public User inviteClassicAgent(String accountId, ClassicAgentToInvite invitee) throws ApiException {
        ClassicAgentToInvite localVarPostBody = invitee;
        if (invitee == null) {
            throw new ApiException(400, "Missing the required parameter 'invitee' when calling inviteClassicAgent");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling inviteClassicAgent");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/invite_classic_agent".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public User inviteClassicManager(String accountId, ClassicManagerToInvite invitee) throws ApiException {
        ClassicManagerToInvite localVarPostBody = invitee;
        if (invitee == null) {
            throw new ApiException(400, "Missing the required parameter 'invitee' when calling inviteClassicManager");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling inviteClassicManager");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/invite_classic_manager".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public User inviteUser(String accountId, UserToInvite invitee) throws ApiException {
        UserToInvite localVarPostBody = invitee;
        if (invitee == null) {
            throw new ApiException(400, "Missing the required parameter 'invitee' when calling inviteUser");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling inviteUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/invite_user".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void lockUser(String accountId, Integer userId, LockedOutDetails details) throws ApiException {
        LockedOutDetails localVarPostBody = details;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling lockUser");
        }
        if (details == null) {
            throw new ApiException(400, "Missing the required parameter 'details' when calling lockUser");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling lockUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/lock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void reinviteUser(String accountId, Integer userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling reinviteUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling reinviteUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/reinvite".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void removeUser(String accountId, Integer userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling removeUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void removeUserFromOffice(String accountId, Integer userId, DesignatedOffice designatedOffice) throws ApiException {
        DesignatedOffice localVarPostBody = designatedOffice;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling removeUserFromOffice");
        }
        if (designatedOffice == null) {
            throw new ApiException(400, "Missing the required parameter 'designatedOffice' when calling removeUserFromOffice");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeUserFromOffice");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/remove_from_office".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void removeUserFromRegion(String accountId, Integer userId, DesignatedRegion designatedRegion) throws ApiException {
        DesignatedRegion localVarPostBody = designatedRegion;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling removeUserFromRegion");
        }
        if (designatedRegion == null) {
            throw new ApiException(400, "Missing the required parameter 'designatedRegion' when calling removeUserFromRegion");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeUserFromRegion");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/remove_from_region".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unlockUser(String accountId, Integer userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling unlockUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unlockUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/unlock".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public User updateUser(String accountId, Integer userId, UserForUpdate userForUpdate) throws ApiException {
        UserForUpdate localVarPostBody = userForUpdate;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateUser");
        }
        if (userForUpdate == null) {
            throw new ApiException(400, "Missing the required parameter 'userForUpdate' when calling updateUser");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<User> localVarReturnType = new GenericType<User>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetUsersOptions {
        private String filter = null;
        private String sort = null;
        private Integer defaultOfficeId = null;
        private String accessLevel = null;
        private Integer titleId = null;
        private Integer roleId = null;
        private String status = null;
        private Boolean lockedOnly = null;
        private Integer startPosition = null;
        private Integer count = null;

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public String getSort() {
            return this.sort;
        }

        public void setDefaultOfficeId(Integer defaultOfficeId) {
            this.defaultOfficeId = defaultOfficeId;
        }

        public Integer getDefaultOfficeId() {
            return this.defaultOfficeId;
        }

        public void setAccessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
        }

        public String getAccessLevel() {
            return this.accessLevel;
        }

        public void setTitleId(Integer titleId) {
            this.titleId = titleId;
        }

        public Integer getTitleId() {
            return this.titleId;
        }

        public void setRoleId(Integer roleId) {
            this.roleId = roleId;
        }

        public Integer getRoleId() {
            return this.roleId;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setLockedOnly(Boolean lockedOnly) {
            this.lockedOnly = lockedOnly;
        }

        public Boolean getLockedOnly() {
            return this.lockedOnly;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }
    }
}

