/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.RoomTemplatesSummaryList;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class RoomTemplatesApi {
    private ApiClient apiClient;

    public RoomTemplatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoomTemplatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RoomTemplatesSummaryList getRoomTemplates(String accountId) throws ApiException {
        return this.getRoomTemplates(accountId, null);
    }

    public RoomTemplatesSummaryList getRoomTemplates(String accountId, GetRoomTemplatesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRoomTemplates");
        }
        String localVarPath = "/v2/accounts/{accountId}/room_templates".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("officeId", options.officeId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("onlyAssignable", options.onlyAssignable));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startPosition", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<RoomTemplatesSummaryList> localVarReturnType = new GenericType<RoomTemplatesSummaryList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetRoomTemplatesOptions {
        private Integer officeId = null;
        private Boolean onlyAssignable = null;
        private Integer count = null;
        private Integer startPosition = null;

        public void setOfficeId(Integer officeId) {
            this.officeId = officeId;
        }

        public Integer getOfficeId() {
            return this.officeId;
        }

        public void setOnlyAssignable(Boolean onlyAssignable) {
            this.onlyAssignable = onlyAssignable;
        }

        public Boolean getOnlyAssignable() {
            return this.onlyAssignable;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setStartPosition(Integer startPosition) {
            this.startPosition = startPosition;
        }

        public Integer getStartPosition() {
            return this.startPosition;
        }
    }
}

