package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

/** EnvelopeMetadata. */
public class EnvelopeMetadata implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("allowAdvancedCorrect")
  private String allowAdvancedCorrect = null;

  @JsonProperty("allowCorrect")
  private String allowCorrect = null;

  @JsonProperty("enableSignWithNotary")
  private String enableSignWithNotary = null;

  /**
   * allowAdvancedCorrect.
   *
   * @return EnvelopeMetadata
   */
  public EnvelopeMetadata allowAdvancedCorrect(String allowAdvancedCorrect) {
    this.allowAdvancedCorrect = allowAdvancedCorrect;
    return this;
  }

  /**
   * .
   *
   * @return allowAdvancedCorrect
   */
  @Schema(description = "")
  public String getAllowAdvancedCorrect() {
    return allowAdvancedCorrect;
  }

  /** setAllowAdvancedCorrect. */
  public void setAllowAdvancedCorrect(String allowAdvancedCorrect) {
    this.allowAdvancedCorrect = allowAdvancedCorrect;
  }

  /**
   * allowCorrect.
   *
   * @return EnvelopeMetadata
   */
  public EnvelopeMetadata allowCorrect(String allowCorrect) {
    this.allowCorrect = allowCorrect;
    return this;
  }

  /**
   * .
   *
   * @return allowCorrect
   */
  @Schema(description = "")
  public String getAllowCorrect() {
    return allowCorrect;
  }

  /** setAllowCorrect. */
  public void setAllowCorrect(String allowCorrect) {
    this.allowCorrect = allowCorrect;
  }

  /**
   * enableSignWithNotary.
   *
   * @return EnvelopeMetadata
   */
  public EnvelopeMetadata enableSignWithNotary(String enableSignWithNotary) {
    this.enableSignWithNotary = enableSignWithNotary;
    return this;
  }

  /**
   * .
   *
   * @return enableSignWithNotary
   */
  @Schema(description = "")
  public String getEnableSignWithNotary() {
    return enableSignWithNotary;
  }

  /** setEnableSignWithNotary. */
  public void setEnableSignWithNotary(String enableSignWithNotary) {
    this.enableSignWithNotary = enableSignWithNotary;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EnvelopeMetadata envelopeMetadata = (EnvelopeMetadata) o;
    return Objects.equals(this.allowAdvancedCorrect, envelopeMetadata.allowAdvancedCorrect)
        && Objects.equals(this.allowCorrect, envelopeMetadata.allowCorrect)
        && Objects.equals(this.enableSignWithNotary, envelopeMetadata.enableSignWithNotary);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(allowAdvancedCorrect, allowCorrect, enableSignWithNotary);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EnvelopeMetadata {\n");

    sb.append("    allowAdvancedCorrect: ")
        .append(toIndentedString(allowAdvancedCorrect))
        .append("\n");
    sb.append("    allowCorrect: ").append(toIndentedString(allowCorrect)).append("\n");
    sb.append("    enableSignWithNotary: ")
        .append(toIndentedString(enableSignWithNotary))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
