/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.BulkRecipientSignatureProvider;
import com.docusign.esign.model.BulkRecipientTabLabel;
import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BulkRecipient {
    @JsonProperty(value="accessCode")
    private String accessCode = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="errorDetails")
    private List<ErrorDetails> errorDetails = null;
    @JsonProperty(value="identification")
    private String identification = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="phoneNumber")
    private String phoneNumber = null;
    @JsonProperty(value="recipientSignatureProviderInfo")
    private List<BulkRecipientSignatureProvider> recipientSignatureProviderInfo = null;
    @JsonProperty(value="rowNumber")
    private String rowNumber = null;
    @JsonProperty(value="tabLabels")
    private List<BulkRecipientTabLabel> tabLabels = null;

    public BulkRecipient accessCode(String accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    @ApiModelProperty(value="If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.")
    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public BulkRecipient email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Specifies the recipient's email address.   Maximum length: 100 characters.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public BulkRecipient errorDetails(List<ErrorDetails> errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    public BulkRecipient addErrorDetailsItem(ErrorDetails errorDetailsItem) {
        if (this.errorDetails == null) {
            this.errorDetails = new ArrayList<ErrorDetails>();
        }
        this.errorDetails.add(errorDetailsItem);
        return this;
    }

    @ApiModelProperty(value="Array or errors.")
    public List<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(List<ErrorDetails> errorDetails) {
        this.errorDetails = errorDetails;
    }

    public BulkRecipient identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(value="Specifies the authentication check used for the signer. If blank then no authentication check is required for the signer. Only one value can be used in this field.  The acceptable values are:  * KBA: Enables the normal ID check authentication set up for your account. * Phone: Enables phone authentication. * SMS: Enables SMS authentication.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public BulkRecipient name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Specifies the recipient's name.   Maximum length: 50 characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BulkRecipient note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public BulkRecipient phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="This is only used if the Identification field value is Phone or SMS. The value for this field can be a valid telephone number or, if Phone, usersupplied (SMS authentication cannot use a user supplied number). Parenthesis and dashes can be used in the telephone number.  If `usersupplied` is used, the signer supplies his or her own telephone number.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public BulkRecipient recipientSignatureProviderInfo(List<BulkRecipientSignatureProvider> recipientSignatureProviderInfo) {
        this.recipientSignatureProviderInfo = recipientSignatureProviderInfo;
        return this;
    }

    public BulkRecipient addRecipientSignatureProviderInfoItem(BulkRecipientSignatureProvider recipientSignatureProviderInfoItem) {
        if (this.recipientSignatureProviderInfo == null) {
            this.recipientSignatureProviderInfo = new ArrayList<BulkRecipientSignatureProvider>();
        }
        this.recipientSignatureProviderInfo.add(recipientSignatureProviderInfoItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<BulkRecipientSignatureProvider> getRecipientSignatureProviderInfo() {
        return this.recipientSignatureProviderInfo;
    }

    public void setRecipientSignatureProviderInfo(List<BulkRecipientSignatureProvider> recipientSignatureProviderInfo) {
        this.recipientSignatureProviderInfo = recipientSignatureProviderInfo;
    }

    public BulkRecipient rowNumber(String rowNumber) {
        this.rowNumber = rowNumber;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(String rowNumber) {
        this.rowNumber = rowNumber;
    }

    public BulkRecipient tabLabels(List<BulkRecipientTabLabel> tabLabels) {
        this.tabLabels = tabLabels;
        return this;
    }

    public BulkRecipient addTabLabelsItem(BulkRecipientTabLabel tabLabelsItem) {
        if (this.tabLabels == null) {
            this.tabLabels = new ArrayList<BulkRecipientTabLabel>();
        }
        this.tabLabels.add(tabLabelsItem);
        return this;
    }

    @ApiModelProperty(value="Specifies values used to populate recipient tabs with information. This allows each bulk recipient signer to have different values for their associated tabs. Any number of `tabLabel` columns can be added to the bulk recipient file.  The information used in the bulk recipient file header must be the same as the `tabLabel` for the tab.  The values entered in this column are automatically inserted into the corresponding tab for the recipient in the same row.  Note that this option cannot be used for tabs that do not have data or that are automatically populated data such as Signature, Full Name, Email Address, Company, Title, and Date Signed tabs.")
    public List<BulkRecipientTabLabel> getTabLabels() {
        return this.tabLabels;
    }

    public void setTabLabels(List<BulkRecipientTabLabel> tabLabels) {
        this.tabLabels = tabLabels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkRecipient bulkRecipient = (BulkRecipient)o;
        return Objects.equals(this.accessCode, bulkRecipient.accessCode) && Objects.equals(this.email, bulkRecipient.email) && Objects.equals(this.errorDetails, bulkRecipient.errorDetails) && Objects.equals(this.identification, bulkRecipient.identification) && Objects.equals(this.name, bulkRecipient.name) && Objects.equals(this.note, bulkRecipient.note) && Objects.equals(this.phoneNumber, bulkRecipient.phoneNumber) && Objects.equals(this.recipientSignatureProviderInfo, bulkRecipient.recipientSignatureProviderInfo) && Objects.equals(this.rowNumber, bulkRecipient.rowNumber) && Objects.equals(this.tabLabels, bulkRecipient.tabLabels);
    }

    public int hashCode() {
        return Objects.hash(this.accessCode, this.email, this.errorDetails, this.identification, this.name, this.note, this.phoneNumber, this.recipientSignatureProviderInfo, this.rowNumber, this.tabLabels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkRecipient {\n");
        sb.append("    accessCode: ").append(this.toIndentedString(this.accessCode)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    recipientSignatureProviderInfo: ").append(this.toIndentedString(this.recipientSignatureProviderInfo)).append("\n");
        sb.append("    rowNumber: ").append(this.toIndentedString(this.rowNumber)).append("\n");
        sb.append("    tabLabels: ").append(this.toIndentedString(this.tabLabels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

