/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AddOn;
import com.docusign.esign.model.DowngradePlanUpdateResponse;
import com.docusign.esign.model.FeatureSet;
import com.docusign.esign.model.SeatDiscount;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains information about an account billing plan.")
public class AccountBillingPlan {
    @JsonProperty(value="addOns")
    private List<AddOn> addOns = new ArrayList<AddOn>();
    @JsonProperty(value="canCancelRenewal")
    private String canCancelRenewal = null;
    @JsonProperty(value="canUpgrade")
    private String canUpgrade = null;
    @JsonProperty(value="currencyCode")
    private String currencyCode = null;
    @JsonProperty(value="downgradePlanInformation")
    private DowngradePlanUpdateResponse downgradePlanInformation = null;
    @JsonProperty(value="enableSupport")
    private String enableSupport = null;
    @JsonProperty(value="includedSeats")
    private String includedSeats = null;
    @JsonProperty(value="incrementalSeats")
    private String incrementalSeats = null;
    @JsonProperty(value="isDowngrade")
    private String isDowngrade = null;
    @JsonProperty(value="otherDiscountPercent")
    private String otherDiscountPercent = null;
    @JsonProperty(value="paymentCycle")
    private String paymentCycle = null;
    @JsonProperty(value="paymentMethod")
    private String paymentMethod = null;
    @JsonProperty(value="perSeatPrice")
    private String perSeatPrice = null;
    @JsonProperty(value="planClassification")
    private String planClassification = null;
    @JsonProperty(value="planFeatureSets")
    private List<FeatureSet> planFeatureSets = new ArrayList<FeatureSet>();
    @JsonProperty(value="planId")
    private String planId = null;
    @JsonProperty(value="planName")
    private String planName = null;
    @JsonProperty(value="renewalStatus")
    private String renewalStatus = null;
    @JsonProperty(value="seatDiscounts")
    private List<SeatDiscount> seatDiscounts = new ArrayList<SeatDiscount>();
    @JsonProperty(value="supportIncidentFee")
    private String supportIncidentFee = null;
    @JsonProperty(value="supportPlanFee")
    private String supportPlanFee = null;

    public AccountBillingPlan addOns(List<AddOn> addOns) {
        this.addOns = addOns;
        return this;
    }

    public AccountBillingPlan addAddOnsItem(AddOn addOnsItem) {
        this.addOns.add(addOnsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved:")
    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public void setAddOns(List<AddOn> addOns) {
        this.addOns = addOns;
    }

    public AccountBillingPlan canCancelRenewal(String canCancelRenewal) {
        this.canCancelRenewal = canCancelRenewal;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getCanCancelRenewal() {
        return this.canCancelRenewal;
    }

    public void setCanCancelRenewal(String canCancelRenewal) {
        this.canCancelRenewal = canCancelRenewal;
    }

    public AccountBillingPlan canUpgrade(String canUpgrade) {
        this.canUpgrade = canUpgrade;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, specifies that you can upgrade the account through the API.")
    public String getCanUpgrade() {
        return this.canUpgrade;
    }

    public void setCanUpgrade(String canUpgrade) {
        this.canUpgrade = canUpgrade;
    }

    public AccountBillingPlan currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the ISO currency code for the account.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public AccountBillingPlan downgradePlanInformation(DowngradePlanUpdateResponse downgradePlanInformation) {
        this.downgradePlanInformation = downgradePlanInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public DowngradePlanUpdateResponse getDowngradePlanInformation() {
        return this.downgradePlanInformation;
    }

    public void setDowngradePlanInformation(DowngradePlanUpdateResponse downgradePlanInformation) {
        this.downgradePlanInformation = downgradePlanInformation;
    }

    public AccountBillingPlan enableSupport(String enableSupport) {
        this.enableSupport = enableSupport;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, then customer support is provided as part of the account plan.")
    public String getEnableSupport() {
        return this.enableSupport;
    }

    public void setEnableSupport(String enableSupport) {
        this.enableSupport = enableSupport;
    }

    public AccountBillingPlan includedSeats(String includedSeats) {
        this.includedSeats = includedSeats;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seats (users) included.")
    public String getIncludedSeats() {
        return this.includedSeats;
    }

    public void setIncludedSeats(String includedSeats) {
        this.includedSeats = includedSeats;
    }

    public AccountBillingPlan incrementalSeats(String incrementalSeats) {
        this.incrementalSeats = incrementalSeats;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getIncrementalSeats() {
        return this.incrementalSeats;
    }

    public void setIncrementalSeats(String incrementalSeats) {
        this.incrementalSeats = incrementalSeats;
    }

    public AccountBillingPlan isDowngrade(String isDowngrade) {
        this.isDowngrade = isDowngrade;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getIsDowngrade() {
        return this.isDowngrade;
    }

    public void setIsDowngrade(String isDowngrade) {
        this.isDowngrade = isDowngrade;
    }

    public AccountBillingPlan otherDiscountPercent(String otherDiscountPercent) {
        this.otherDiscountPercent = otherDiscountPercent;
        return this;
    }

    @ApiModelProperty(example="null", value=" Any other percentage discount for the plan. ")
    public String getOtherDiscountPercent() {
        return this.otherDiscountPercent;
    }

    public void setOtherDiscountPercent(String otherDiscountPercent) {
        this.otherDiscountPercent = otherDiscountPercent;
    }

    public AccountBillingPlan paymentCycle(String paymentCycle) {
        this.paymentCycle = paymentCycle;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPaymentCycle() {
        return this.paymentCycle;
    }

    public void setPaymentCycle(String paymentCycle) {
        this.paymentCycle = paymentCycle;
    }

    public AccountBillingPlan paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(example="null", value=" The payment method used with the plan. The possible values are: CreditCard, PurchaseOrder, Premium, or Freemium. ")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public AccountBillingPlan perSeatPrice(String perSeatPrice) {
        this.perSeatPrice = perSeatPrice;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPerSeatPrice() {
        return this.perSeatPrice;
    }

    public void setPerSeatPrice(String perSeatPrice) {
        this.perSeatPrice = perSeatPrice;
    }

    public AccountBillingPlan planClassification(String planClassification) {
        this.planClassification = planClassification;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifies the type of plan. Examples include Business, Corporate, Enterprise, Free.")
    public String getPlanClassification() {
        return this.planClassification;
    }

    public void setPlanClassification(String planClassification) {
        this.planClassification = planClassification;
    }

    public AccountBillingPlan planFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
        return this;
    }

    public AccountBillingPlan addPlanFeatureSetsItem(FeatureSet planFeatureSetsItem) {
        this.planFeatureSets.add(planFeatureSetsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A complex type that sets the feature sets for the account. It contains the following information (all string content):  * currencyFeatureSetPrices - Contains the currencyCode and currencySymbol for the alternate currency values for envelopeFee, fixedFee, seatFee that are configured for this plan feature set. * envelopeFee - An incremental envelope cost for plans with envelope overages (when isEnabled=true). * featureSetId - A unique ID for the feature set. * fixedFee - A one-time fee associated with the plan (when isEnabled=true). * isActive - Specifies whether the feature set is actively set as part of the plan. * isEnabled - Specifies whether the feature set is actively enabled as part of the plan. * name - The name of the feature set. * seatFee - An incremental seat cost for seat-based plans (when isEnabled=true). ")
    public List<FeatureSet> getPlanFeatureSets() {
        return this.planFeatureSets;
    }

    public void setPlanFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
    }

    public AccountBillingPlan planId(String planId) {
        this.planId = planId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public AccountBillingPlan planName(String planName) {
        this.planName = planName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the Billing Plan.")
    public String getPlanName() {
        return this.planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public AccountBillingPlan renewalStatus(String renewalStatus) {
        this.renewalStatus = renewalStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The renewal status for the account. The acceptable values are:  * auto: The account automatically renews. * queued_for_close: Account will be closed at the billingPeriodEndDate. * queued_for_downgrade: Account will be downgraded at the billingPeriodEndDate.")
    public String getRenewalStatus() {
        return this.renewalStatus;
    }

    public void setRenewalStatus(String renewalStatus) {
        this.renewalStatus = renewalStatus;
    }

    public AccountBillingPlan seatDiscounts(List<SeatDiscount> seatDiscounts) {
        this.seatDiscounts = seatDiscounts;
        return this;
    }

    public AccountBillingPlan addSeatDiscountsItem(SeatDiscount seatDiscountsItem) {
        this.seatDiscounts.add(seatDiscountsItem);
        return this;
    }

    @ApiModelProperty(example="null", value=" A complex type that contains any seat discount information.  Values are: BeginSeatCount, EndSeatCount, and SeatDiscountPercent.  ")
    public List<SeatDiscount> getSeatDiscounts() {
        return this.seatDiscounts;
    }

    public void setSeatDiscounts(List<SeatDiscount> seatDiscounts) {
        this.seatDiscounts = seatDiscounts;
    }

    public AccountBillingPlan supportIncidentFee(String supportIncidentFee) {
        this.supportIncidentFee = supportIncidentFee;
        return this;
    }

    @ApiModelProperty(example="null", value="The support incident fee charged for each support incident.")
    public String getSupportIncidentFee() {
        return this.supportIncidentFee;
    }

    public void setSupportIncidentFee(String supportIncidentFee) {
        this.supportIncidentFee = supportIncidentFee;
    }

    public AccountBillingPlan supportPlanFee(String supportPlanFee) {
        this.supportPlanFee = supportPlanFee;
        return this;
    }

    @ApiModelProperty(example="null", value="The support plan fee charged for this plan.")
    public String getSupportPlanFee() {
        return this.supportPlanFee;
    }

    public void setSupportPlanFee(String supportPlanFee) {
        this.supportPlanFee = supportPlanFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountBillingPlan accountBillingPlan = (AccountBillingPlan)o;
        return Objects.equals(this.addOns, accountBillingPlan.addOns) && Objects.equals(this.canCancelRenewal, accountBillingPlan.canCancelRenewal) && Objects.equals(this.canUpgrade, accountBillingPlan.canUpgrade) && Objects.equals(this.currencyCode, accountBillingPlan.currencyCode) && Objects.equals(this.downgradePlanInformation, accountBillingPlan.downgradePlanInformation) && Objects.equals(this.enableSupport, accountBillingPlan.enableSupport) && Objects.equals(this.includedSeats, accountBillingPlan.includedSeats) && Objects.equals(this.incrementalSeats, accountBillingPlan.incrementalSeats) && Objects.equals(this.isDowngrade, accountBillingPlan.isDowngrade) && Objects.equals(this.otherDiscountPercent, accountBillingPlan.otherDiscountPercent) && Objects.equals(this.paymentCycle, accountBillingPlan.paymentCycle) && Objects.equals(this.paymentMethod, accountBillingPlan.paymentMethod) && Objects.equals(this.perSeatPrice, accountBillingPlan.perSeatPrice) && Objects.equals(this.planClassification, accountBillingPlan.planClassification) && Objects.equals(this.planFeatureSets, accountBillingPlan.planFeatureSets) && Objects.equals(this.planId, accountBillingPlan.planId) && Objects.equals(this.planName, accountBillingPlan.planName) && Objects.equals(this.renewalStatus, accountBillingPlan.renewalStatus) && Objects.equals(this.seatDiscounts, accountBillingPlan.seatDiscounts) && Objects.equals(this.supportIncidentFee, accountBillingPlan.supportIncidentFee) && Objects.equals(this.supportPlanFee, accountBillingPlan.supportPlanFee);
    }

    public int hashCode() {
        return Objects.hash(this.addOns, this.canCancelRenewal, this.canUpgrade, this.currencyCode, this.downgradePlanInformation, this.enableSupport, this.includedSeats, this.incrementalSeats, this.isDowngrade, this.otherDiscountPercent, this.paymentCycle, this.paymentMethod, this.perSeatPrice, this.planClassification, this.planFeatureSets, this.planId, this.planName, this.renewalStatus, this.seatDiscounts, this.supportIncidentFee, this.supportPlanFee);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountBillingPlan {\n");
        sb.append("    addOns: ").append(this.toIndentedString(this.addOns)).append("\n");
        sb.append("    canCancelRenewal: ").append(this.toIndentedString(this.canCancelRenewal)).append("\n");
        sb.append("    canUpgrade: ").append(this.toIndentedString(this.canUpgrade)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    downgradePlanInformation: ").append(this.toIndentedString(this.downgradePlanInformation)).append("\n");
        sb.append("    enableSupport: ").append(this.toIndentedString(this.enableSupport)).append("\n");
        sb.append("    includedSeats: ").append(this.toIndentedString(this.includedSeats)).append("\n");
        sb.append("    incrementalSeats: ").append(this.toIndentedString(this.incrementalSeats)).append("\n");
        sb.append("    isDowngrade: ").append(this.toIndentedString(this.isDowngrade)).append("\n");
        sb.append("    otherDiscountPercent: ").append(this.toIndentedString(this.otherDiscountPercent)).append("\n");
        sb.append("    paymentCycle: ").append(this.toIndentedString(this.paymentCycle)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    perSeatPrice: ").append(this.toIndentedString(this.perSeatPrice)).append("\n");
        sb.append("    planClassification: ").append(this.toIndentedString(this.planClassification)).append("\n");
        sb.append("    planFeatureSets: ").append(this.toIndentedString(this.planFeatureSets)).append("\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    planName: ").append(this.toIndentedString(this.planName)).append("\n");
        sb.append("    renewalStatus: ").append(this.toIndentedString(this.renewalStatus)).append("\n");
        sb.append("    seatDiscounts: ").append(this.toIndentedString(this.seatDiscounts)).append("\n");
        sb.append("    supportIncidentFee: ").append(this.toIndentedString(this.supportIncidentFee)).append("\n");
        sb.append("    supportPlanFee: ").append(this.toIndentedString(this.supportPlanFee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

