/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.BillingDiscount;
import com.docusign.esign.model.BillingPrice;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains information about a billing charge.")
public class BillingCharge {
    @JsonProperty(value="allowedQuantity")
    private String allowedQuantity = null;
    @JsonProperty(value="blocked")
    private String blocked = null;
    @JsonProperty(value="chargeName")
    private String chargeName = null;
    @JsonProperty(value="chargeType")
    private String chargeType = null;
    @JsonProperty(value="chargeUnitOfMeasure")
    private String chargeUnitOfMeasure = null;
    @JsonProperty(value="discounts")
    private List<BillingDiscount> discounts = new ArrayList<BillingDiscount>();
    @JsonProperty(value="firstEffectiveDate")
    private String firstEffectiveDate = null;
    @JsonProperty(value="includedQuantity")
    private String includedQuantity = null;
    @JsonProperty(value="incrementalQuantity")
    private String incrementalQuantity = null;
    @JsonProperty(value="lastEffectiveDate")
    private String lastEffectiveDate = null;
    @JsonProperty(value="prices")
    private List<BillingPrice> prices = new ArrayList<BillingPrice>();
    @JsonProperty(value="unitPrice")
    private String unitPrice = null;
    @JsonProperty(value="usedQuantity")
    private String usedQuantity = null;

    public BillingCharge allowedQuantity(String allowedQuantity) {
        this.allowedQuantity = allowedQuantity;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getAllowedQuantity() {
        return this.allowedQuantity;
    }

    public void setAllowedQuantity(String allowedQuantity) {
        this.allowedQuantity = allowedQuantity;
    }

    public BillingCharge blocked(String blocked) {
        this.blocked = blocked;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getBlocked() {
        return this.blocked;
    }

    public void setBlocked(String blocked) {
        this.blocked = blocked;
    }

    public BillingCharge chargeName(String chargeName) {
        this.chargeName = chargeName;
        return this;
    }

    @ApiModelProperty(example="null", value="Provides information on what services the charge item is for.  The following table provides a description of the different chargeName values available at this time.  | chargeName | Description | | --- | --- | | id_check | ID\u00c2\u00a0Check Charge | | in_person_signing | In Person Signing charge | | envelopes Included | Sent Envelopes for the account | | age_verify | Age verification check | | ofac | OFAC Check | | id_confirm | ID confirmation check | | student_authentication | STAN PIN authentication check | | wet_sign_fax | Pages for returning signed documents by fax | | attachment_fax | Pages for returning attachments by fax | | phone_authentication | Phone authentication charge | | powerforms | PowerForm envelopes sent | | signer_payments | Payment processing charge | | outbound_fax | Send by fax charge | | bulk_recipient_envelopes | Bulk Recipient Envelopes sent | | sms_authentications | SMS authentication charge | | saml_authentications | SAML authentication charge | | express_signer_certificate | DocuSign Express Certificate charge | | personal_signer_certificate | Personal Signer Certificate charge | | safe_certificate | SAFE BioPharma Signer Certificate charge | | seats | Included active seats charge | | open_trust_certificate | OpenTrust Signer Certificate charge |")
    public String getChargeName() {
        return this.chargeName;
    }

    public void setChargeName(String chargeName) {
        this.chargeName = chargeName;
    }

    public BillingCharge chargeType(String chargeType) {
        this.chargeType = chargeType;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public BillingCharge chargeUnitOfMeasure(String chargeUnitOfMeasure) {
        this.chargeUnitOfMeasure = chargeUnitOfMeasure;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getChargeUnitOfMeasure() {
        return this.chargeUnitOfMeasure;
    }

    public void setChargeUnitOfMeasure(String chargeUnitOfMeasure) {
        this.chargeUnitOfMeasure = chargeUnitOfMeasure;
    }

    public BillingCharge discounts(List<BillingDiscount> discounts) {
        this.discounts = discounts;
        return this;
    }

    public BillingCharge addDiscountsItem(BillingDiscount discountsItem) {
        this.discounts.add(discountsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<BillingDiscount> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<BillingDiscount> discounts) {
        this.discounts = discounts;
    }

    public BillingCharge firstEffectiveDate(String firstEffectiveDate) {
        this.firstEffectiveDate = firstEffectiveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getFirstEffectiveDate() {
        return this.firstEffectiveDate;
    }

    public void setFirstEffectiveDate(String firstEffectiveDate) {
        this.firstEffectiveDate = firstEffectiveDate;
    }

    public BillingCharge includedQuantity(String includedQuantity) {
        this.includedQuantity = includedQuantity;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getIncludedQuantity() {
        return this.includedQuantity;
    }

    public void setIncludedQuantity(String includedQuantity) {
        this.includedQuantity = includedQuantity;
    }

    public BillingCharge incrementalQuantity(String incrementalQuantity) {
        this.incrementalQuantity = incrementalQuantity;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getIncrementalQuantity() {
        return this.incrementalQuantity;
    }

    public void setIncrementalQuantity(String incrementalQuantity) {
        this.incrementalQuantity = incrementalQuantity;
    }

    public BillingCharge lastEffectiveDate(String lastEffectiveDate) {
        this.lastEffectiveDate = lastEffectiveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getLastEffectiveDate() {
        return this.lastEffectiveDate;
    }

    public void setLastEffectiveDate(String lastEffectiveDate) {
        this.lastEffectiveDate = lastEffectiveDate;
    }

    public BillingCharge prices(List<BillingPrice> prices) {
        this.prices = prices;
        return this;
    }

    public BillingCharge addPricesItem(BillingPrice pricesItem) {
        this.prices.add(pricesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<BillingPrice> getPrices() {
        return this.prices;
    }

    public void setPrices(List<BillingPrice> prices) {
        this.prices = prices;
    }

    public BillingCharge unitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @ApiModelProperty(example="null", value="Reserved: TBD")
    public String getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BillingCharge usedQuantity(String usedQuantity) {
        this.usedQuantity = usedQuantity;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getUsedQuantity() {
        return this.usedQuantity;
    }

    public void setUsedQuantity(String usedQuantity) {
        this.usedQuantity = usedQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingCharge billingCharge = (BillingCharge)o;
        return Objects.equals(this.allowedQuantity, billingCharge.allowedQuantity) && Objects.equals(this.blocked, billingCharge.blocked) && Objects.equals(this.chargeName, billingCharge.chargeName) && Objects.equals(this.chargeType, billingCharge.chargeType) && Objects.equals(this.chargeUnitOfMeasure, billingCharge.chargeUnitOfMeasure) && Objects.equals(this.discounts, billingCharge.discounts) && Objects.equals(this.firstEffectiveDate, billingCharge.firstEffectiveDate) && Objects.equals(this.includedQuantity, billingCharge.includedQuantity) && Objects.equals(this.incrementalQuantity, billingCharge.incrementalQuantity) && Objects.equals(this.lastEffectiveDate, billingCharge.lastEffectiveDate) && Objects.equals(this.prices, billingCharge.prices) && Objects.equals(this.unitPrice, billingCharge.unitPrice) && Objects.equals(this.usedQuantity, billingCharge.usedQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.allowedQuantity, this.blocked, this.chargeName, this.chargeType, this.chargeUnitOfMeasure, this.discounts, this.firstEffectiveDate, this.includedQuantity, this.incrementalQuantity, this.lastEffectiveDate, this.prices, this.unitPrice, this.usedQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingCharge {\n");
        sb.append("    allowedQuantity: ").append(this.toIndentedString(this.allowedQuantity)).append("\n");
        sb.append("    blocked: ").append(this.toIndentedString(this.blocked)).append("\n");
        sb.append("    chargeName: ").append(this.toIndentedString(this.chargeName)).append("\n");
        sb.append("    chargeType: ").append(this.toIndentedString(this.chargeType)).append("\n");
        sb.append("    chargeUnitOfMeasure: ").append(this.toIndentedString(this.chargeUnitOfMeasure)).append("\n");
        sb.append("    discounts: ").append(this.toIndentedString(this.discounts)).append("\n");
        sb.append("    firstEffectiveDate: ").append(this.toIndentedString(this.firstEffectiveDate)).append("\n");
        sb.append("    includedQuantity: ").append(this.toIndentedString(this.includedQuantity)).append("\n");
        sb.append("    incrementalQuantity: ").append(this.toIndentedString(this.incrementalQuantity)).append("\n");
        sb.append("    lastEffectiveDate: ").append(this.toIndentedString(this.lastEffectiveDate)).append("\n");
        sb.append("    prices: ").append(this.toIndentedString(this.prices)).append("\n");
        sb.append("    unitPrice: ").append(this.toIndentedString(this.unitPrice)).append("\n");
        sb.append("    usedQuantity: ").append(this.toIndentedString(this.usedQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

