/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.ContactGetResponse;
import com.docusign.esign.model.ContactModRequest;
import com.docusign.esign.model.ContactUpdateResponse;
import com.docusign.esign.model.CustomSettingsInformation;
import com.docusign.esign.model.NewUsersDefinition;
import com.docusign.esign.model.NewUsersSummary;
import com.docusign.esign.model.UserInfoList;
import com.docusign.esign.model.UserInformation;
import com.docusign.esign.model.UserInformationList;
import com.docusign.esign.model.UserProfile;
import com.docusign.esign.model.UserSettingsInformation;
import com.docusign.esign.model.UserSignature;
import com.docusign.esign.model.UserSignatureDefinition;
import com.docusign.esign.model.UserSignaturesInformation;
import com.docusign.esign.model.UsersResponse;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public NewUsersSummary create(String accountId, NewUsersDefinition newUsersDefinition) throws ApiException {
        NewUsersDefinition localVarPostBody = newUsersDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling create");
        }
        String localVarPath = "/v2/accounts/{accountId}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NewUsersSummary> localVarReturnType = new GenericType<NewUsersSummary>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserSignaturesInformation createSignatures(String accountId, String userId, UserSignaturesInformation userSignaturesInformation) throws ApiException {
        UserSignaturesInformation localVarPostBody = userSignaturesInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createSignatures");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling createSignatures");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/signatures".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignaturesInformation> localVarReturnType = new GenericType<UserSignaturesInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UsersResponse delete(String accountId, UserInfoList userInfoList) throws ApiException {
        return this.delete(accountId, userInfoList, null);
    }

    public UsersResponse delete(String accountId, UserInfoList userInfoList, DeleteOptions options) throws ApiException {
        UserInfoList localVarPostBody = userInfoList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling delete");
        }
        String localVarPath = "/v2/accounts/{accountId}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "delete", options.delete));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UsersResponse> localVarReturnType = new GenericType<UsersResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ContactUpdateResponse deleteContactWithId(String accountId, String contactId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteContactWithId");
        }
        if (contactId == null) {
            throw new ApiException(400, "Missing the required parameter 'contactId' when calling deleteContactWithId");
        }
        String localVarPath = "/v2/accounts/{accountId}/contacts/{contactId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{contactId\\}", this.apiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactUpdateResponse> localVarReturnType = new GenericType<ContactUpdateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ContactUpdateResponse deleteContacts(String accountId, ContactModRequest contactModRequest) throws ApiException {
        ContactModRequest localVarPostBody = contactModRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteContacts");
        }
        String localVarPath = "/v2/accounts/{accountId}/contacts".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactUpdateResponse> localVarReturnType = new GenericType<ContactUpdateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomSettingsInformation deleteCustomSettings(String accountId, String userId, CustomSettingsInformation customSettingsInformation) throws ApiException {
        CustomSettingsInformation localVarPostBody = customSettingsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteCustomSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteCustomSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/custom_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomSettingsInformation> localVarReturnType = new GenericType<CustomSettingsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteProfileImage(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteProfileImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteProfileImage");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/profile/image".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteSignature(String accountId, String userId, String signatureId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteSignature");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteSignature");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling deleteSignature");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/signatures/{signatureId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public UserSignature deleteSignatureImage(String accountId, String userId, String signatureId, String imageType) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteSignatureImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteSignatureImage");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling deleteSignatureImage");
        }
        if (imageType == null) {
            throw new ApiException(400, "Missing the required parameter 'imageType' when calling deleteSignatureImage");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString())).replaceAll("\\{imageType\\}", this.apiClient.escapeString(imageType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ContactGetResponse getContactById(String accountId, String contactId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getContactById");
        }
        if (contactId == null) {
            throw new ApiException(400, "Missing the required parameter 'contactId' when calling getContactById");
        }
        String localVarPath = "/v2/accounts/{accountId}/contacts/{contactId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{contactId\\}", this.apiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactGetResponse> localVarReturnType = new GenericType<ContactGetResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserInformation getInformation(String accountId, String userId) throws ApiException {
        return this.getInformation(accountId, userId, null);
    }

    public UserInformation getInformation(String accountId, String userId, GetInformationOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getInformation");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getInformation");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "additional_info", options.additionalInfo));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "email", options.email));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserInformation> localVarReturnType = new GenericType<UserInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserProfile getProfile(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getProfile");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getProfile");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/profile".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserProfile> localVarReturnType = new GenericType<UserProfile>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public byte[] getProfileImage(String accountId, String userId) throws ApiException {
        return this.getProfileImage(accountId, userId, null);
    }

    public byte[] getProfileImage(String accountId, String userId, GetProfileImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getProfileImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getProfileImage");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/profile/image".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "encoding", options.encoding));
        }
        String[] localVarAccepts = new String[]{"image/gif"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserSettingsInformation getSettings(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSettingsInformation> localVarReturnType = new GenericType<UserSettingsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserSignature getSignature(String accountId, String userId, String signatureId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getSignature");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getSignature");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling getSignature");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/signatures/{signatureId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public byte[] getSignatureImage(String accountId, String userId, String signatureId, String imageType) throws ApiException {
        return this.getSignatureImage(accountId, userId, signatureId, imageType, null);
    }

    public byte[] getSignatureImage(String accountId, String userId, String signatureId, String imageType, GetSignatureImageOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getSignatureImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getSignatureImage");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling getSignatureImage");
        }
        if (imageType == null) {
            throw new ApiException(400, "Missing the required parameter 'imageType' when calling getSignatureImage");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString())).replaceAll("\\{imageType\\}", this.apiClient.escapeString(imageType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_chrome", options.includeChrome));
        }
        String[] localVarAccepts = new String[]{"image/gif"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserInformationList list(String accountId) throws ApiException {
        return this.list(accountId, null);
    }

    public UserInformationList list(String accountId, ListOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling list");
        }
        String localVarPath = "/v2/accounts/{accountId}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "additional_info", options.additionalInfo));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", options.count));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "email", options.email));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "email_substring", options.emailSubstring));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_id", options.groupId));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "login_status", options.loginStatus));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "not_group_id", options.notGroupId));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", options.status));
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "user_name_substring", options.userNameSubstring));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserInformationList> localVarReturnType = new GenericType<UserInformationList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomSettingsInformation listCustomSettings(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listCustomSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listCustomSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/custom_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomSettingsInformation> localVarReturnType = new GenericType<CustomSettingsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserSignaturesInformation listSignatures(String accountId, String userId) throws ApiException {
        return this.listSignatures(accountId, userId, null);
    }

    public UserSignaturesInformation listSignatures(String accountId, String userId, ListSignaturesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listSignatures");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSignatures");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/signatures".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "stamp_type", options.stampType));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignaturesInformation> localVarReturnType = new GenericType<UserSignaturesInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ContactUpdateResponse postContacts(String accountId, ContactModRequest contactModRequest) throws ApiException {
        ContactModRequest localVarPostBody = contactModRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling postContacts");
        }
        String localVarPath = "/v2/accounts/{accountId}/contacts".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactUpdateResponse> localVarReturnType = new GenericType<ContactUpdateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ContactUpdateResponse putContacts(String accountId, ContactModRequest contactModRequest) throws ApiException {
        ContactModRequest localVarPostBody = contactModRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling putContacts");
        }
        String localVarPath = "/v2/accounts/{accountId}/contacts".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ContactUpdateResponse> localVarReturnType = new GenericType<ContactUpdateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomSettingsInformation updateCustomSettings(String accountId, String userId, CustomSettingsInformation customSettingsInformation) throws ApiException {
        CustomSettingsInformation localVarPostBody = customSettingsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateCustomSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateCustomSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/custom_settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<CustomSettingsInformation> localVarReturnType = new GenericType<CustomSettingsInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateProfile(String accountId, String userId, UserProfile userProfile) throws ApiException {
        UserProfile localVarPostBody = userProfile;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateProfile");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateProfile");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/profile".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateProfileImage(String accountId, String userId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateProfileImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateProfileImage");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/profile/image".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateSettings(String accountId, String userId, UserSettingsInformation userSettingsInformation) throws ApiException {
        UserSettingsInformation localVarPostBody = userSettingsInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSettings");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateSettings");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/settings".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public UserSignature updateSignature(String accountId, String userId, String signatureId, UserSignatureDefinition userSignatureDefinition) throws ApiException {
        return this.updateSignature(accountId, userId, signatureId, userSignatureDefinition, null);
    }

    public UserSignature updateSignature(String accountId, String userId, String signatureId, UserSignatureDefinition userSignatureDefinition, UpdateSignatureOptions options) throws ApiException {
        UserSignatureDefinition localVarPostBody = userSignatureDefinition;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSignature");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateSignature");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling updateSignature");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/signatures/{signatureId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "close_existing_signature", options.closeExistingSignature));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserSignature updateSignatureImage(String accountId, String userId, String signatureId, String imageType) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSignatureImage");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateSignatureImage");
        }
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling updateSignatureImage");
        }
        if (imageType == null) {
            throw new ApiException(400, "Missing the required parameter 'imageType' when calling updateSignatureImage");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{signatureId\\}", this.apiClient.escapeString(signatureId.toString())).replaceAll("\\{imageType\\}", this.apiClient.escapeString(imageType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignature> localVarReturnType = new GenericType<UserSignature>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserSignaturesInformation updateSignatures(String accountId, String userId, UserSignaturesInformation userSignaturesInformation) throws ApiException {
        UserSignaturesInformation localVarPostBody = userSignaturesInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateSignatures");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateSignatures");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}/signatures".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserSignaturesInformation> localVarReturnType = new GenericType<UserSignaturesInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserInformation updateUser(String accountId, String userId, UserInformation userInformation) throws ApiException {
        UserInformation localVarPostBody = userInformation;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateUser");
        }
        String localVarPath = "/v2/accounts/{accountId}/users/{userId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserInformation> localVarReturnType = new GenericType<UserInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserInformationList updateUsers(String accountId, UserInformationList userInformationList) throws ApiException {
        UserInformationList localVarPostBody = userInformationList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateUsers");
        }
        String localVarPath = "/v2/accounts/{accountId}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserInformationList> localVarReturnType = new GenericType<UserInformationList>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class UpdateSignatureOptions {
        private String closeExistingSignature = null;

        public void setCloseExistingSignature(String closeExistingSignature) {
            this.closeExistingSignature = closeExistingSignature;
        }

        public String getCloseExistingSignature() {
            return this.closeExistingSignature;
        }
    }

    public class ListSignaturesOptions {
        private String stampType = null;

        public void setStampType(String stampType) {
            this.stampType = stampType;
        }

        public String getStampType() {
            return this.stampType;
        }
    }

    public class ListOptions {
        private String additionalInfo = null;
        private String count = null;
        private String email = null;
        private String emailSubstring = null;
        private String groupId = null;
        private String loginStatus = null;
        private String notGroupId = null;
        private String startPosition = null;
        private String status = null;
        private String userNameSubstring = null;

        public void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmailSubstring(String emailSubstring) {
            this.emailSubstring = emailSubstring;
        }

        public String getEmailSubstring() {
            return this.emailSubstring;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setLoginStatus(String loginStatus) {
            this.loginStatus = loginStatus;
        }

        public String getLoginStatus() {
            return this.loginStatus;
        }

        public void setNotGroupId(String notGroupId) {
            this.notGroupId = notGroupId;
        }

        public String getNotGroupId() {
            return this.notGroupId;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setUserNameSubstring(String userNameSubstring) {
            this.userNameSubstring = userNameSubstring;
        }

        public String getUserNameSubstring() {
            return this.userNameSubstring;
        }
    }

    public class GetSignatureImageOptions {
        private String includeChrome = null;

        public void setIncludeChrome(String includeChrome) {
            this.includeChrome = includeChrome;
        }

        public String getIncludeChrome() {
            return this.includeChrome;
        }
    }

    public class GetProfileImageOptions {
        private String encoding = null;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public class GetInformationOptions {
        private String additionalInfo = null;
        private String email = null;

        public void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }
    }

    public class DeleteOptions {
        private String delete = null;

        public void setDelete(String delete) {
            this.delete = delete;
        }

        public String getDelete() {
            return this.delete;
        }
    }
}

