/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains address information.")
public class AddressInformation {
    private String street1 = null;
    private String street2 = null;
    private String city = null;
    private String state = null;
    private String zip = null;
    private String phone = null;
    private String fax = null;
    private String country = null;

    public AddressInformation street1(String street1) {
        this.street1 = street1;
        return this;
    }

    @ApiModelProperty(example="null", value="The first line of the address.")
    @JsonProperty(value="street1")
    public String getStreet1() {
        return this.street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
    }

    public AddressInformation street2(String street2) {
        this.street2 = street2;
        return this;
    }

    @ApiModelProperty(example="null", value="The second line of the address (optional).")
    @JsonProperty(value="street2")
    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public AddressInformation city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(example="null", value="The city associated with the address.")
    @JsonProperty(value="city")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public AddressInformation state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state or province associated with the address.")
    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AddressInformation zip(String zip) {
        this.zip = zip;
        return this;
    }

    @ApiModelProperty(example="null", value="The zip or postal code associated with the address.")
    @JsonProperty(value="zip")
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public AddressInformation phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(example="null", value="A phone number associated with the address.")
    @JsonProperty(value="phone")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public AddressInformation fax(String fax) {
        this.fax = fax;
        return this;
    }

    @ApiModelProperty(example="null", value="A Fax number associated with the address if one is available.")
    @JsonProperty(value="fax")
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public AddressInformation country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the country associated with the address.")
    @JsonProperty(value="country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressInformation addressInformation = (AddressInformation)o;
        return Objects.equals(this.street1, addressInformation.street1) && Objects.equals(this.street2, addressInformation.street2) && Objects.equals(this.city, addressInformation.city) && Objects.equals(this.state, addressInformation.state) && Objects.equals(this.zip, addressInformation.zip) && Objects.equals(this.phone, addressInformation.phone) && Objects.equals(this.fax, addressInformation.fax) && Objects.equals(this.country, addressInformation.country);
    }

    public int hashCode() {
        return Objects.hash(this.street1, this.street2, this.city, this.state, this.zip, this.phone, this.fax, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressInformation {\n");
        sb.append("    street1: ").append(this.toIndentedString(this.street1)).append("\n");
        sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    zip: ").append(this.toIndentedString(this.zip)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    fax: ").append(this.toIndentedString(this.fax)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

