/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.api;

import com.docusign.click.client.ApiClient;
import com.docusign.click.client.ApiException;
import com.docusign.click.client.Configuration;
import com.docusign.click.client.Pair;
import com.docusign.click.model.ClickwrapAgreementsResponse;
import com.docusign.click.model.ClickwrapRequest;
import com.docusign.click.model.ClickwrapTransferRequest;
import com.docusign.click.model.ClickwrapVersionDeleteResponse;
import com.docusign.click.model.ClickwrapVersionResponse;
import com.docusign.click.model.ClickwrapVersionSummaryResponse;
import com.docusign.click.model.ClickwrapVersionsDeleteResponse;
import com.docusign.click.model.ClickwrapVersionsPagedResponse;
import com.docusign.click.model.ClickwrapVersionsResponse;
import com.docusign.click.model.ClickwrapsDeleteResponse;
import com.docusign.click.model.ServiceInformation;
import com.docusign.click.model.UserAgreementRequest;
import com.docusign.click.model.UserAgreementResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class AccountsApi {
    private ApiClient apiClient;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ClickwrapVersionSummaryResponse createClickwrap(String accountId, ClickwrapRequest clickwrapRequest) throws ApiException {
        ClickwrapRequest localVarPostBody = clickwrapRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createClickwrap");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionSummaryResponse createClickwrapVersion(String accountId, String clickwrapId, ClickwrapRequest clickwrapRequest) throws ApiException {
        ClickwrapRequest localVarPostBody = clickwrapRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createClickwrapVersion");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling createClickwrapVersion");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserAgreementResponse createHasAgreed(String accountId, String clickwrapId, UserAgreementRequest userAgreementRequest) throws ApiException {
        UserAgreementRequest localVarPostBody = userAgreementRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createHasAgreed");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling createHasAgreed");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserAgreementResponse> localVarReturnType = new GenericType<UserAgreementResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionsDeleteResponse deleteClickwrap(String accountId, String clickwrapId) throws ApiException {
        return this.deleteClickwrap(accountId, clickwrapId, null);
    }

    public ClickwrapVersionsDeleteResponse deleteClickwrap(String accountId, String clickwrapId, DeleteClickwrapOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteClickwrap");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling deleteClickwrap");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("versions", options.versions));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionsDeleteResponse> localVarReturnType = new GenericType<ClickwrapVersionsDeleteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionDeleteResponse deleteClickwrapVersion(String accountId, String clickwrapId, String versionId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteClickwrapVersion");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling deleteClickwrapVersion");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling deleteClickwrapVersion");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionId\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionDeleteResponse> localVarReturnType = new GenericType<ClickwrapVersionDeleteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionSummaryResponse deleteClickwrapVersionByNumber(String accountId, String clickwrapId, String versionNumber) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteClickwrapVersionByNumber");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling deleteClickwrapVersionByNumber");
        }
        if (versionNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'versionNumber' when calling deleteClickwrapVersionByNumber");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionNumber}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionNumber\\}", this.apiClient.escapeString(versionNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionsDeleteResponse deleteClickwrapVersions(String accountId, String clickwrapId) throws ApiException {
        return this.deleteClickwrapVersions(accountId, clickwrapId, null);
    }

    public ClickwrapVersionsDeleteResponse deleteClickwrapVersions(String accountId, String clickwrapId, DeleteClickwrapVersionsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteClickwrapVersions");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling deleteClickwrapVersions");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("clickwrapVersionIds", options.clickwrapVersionIds));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionsDeleteResponse> localVarReturnType = new GenericType<ClickwrapVersionsDeleteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapsDeleteResponse deleteClickwraps(String accountId) throws ApiException {
        return this.deleteClickwraps(accountId, null);
    }

    public ClickwrapsDeleteResponse deleteClickwraps(String accountId, DeleteClickwrapsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteClickwraps");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("clickwrapIds", options.clickwrapIds));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapsDeleteResponse> localVarReturnType = new GenericType<ClickwrapsDeleteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserAgreementResponse getAgreement(String accountId, String clickwrapId, String agreementId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAgreement");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getAgreement");
        }
        if (agreementId == null) {
            throw new ApiException(400, "Missing the required parameter 'agreementId' when calling getAgreement");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements/{agreementId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UserAgreementResponse> localVarReturnType = new GenericType<UserAgreementResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void getAgreementPdf(String accountId, String clickwrapId, String agreementId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAgreementPdf");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getAgreementPdf");
        }
        if (agreementId == null) {
            throw new ApiException(400, "Missing the required parameter 'agreementId' when calling getAgreementPdf");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements/{agreementId}/download".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ClickwrapVersionResponse getClickwrap(String accountId, String clickwrapId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrap");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrap");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionResponse> localVarReturnType = new GenericType<ClickwrapVersionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapAgreementsResponse getClickwrapAgreements(String accountId, String clickwrapId) throws ApiException {
        return this.getClickwrapAgreements(accountId, clickwrapId, null);
    }

    public ClickwrapAgreementsResponse getClickwrapAgreements(String accountId, String clickwrapId, GetClickwrapAgreementsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapAgreements");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapAgreements");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_user_id", options.clientUserId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_number", options.pageNumber));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapAgreementsResponse> localVarReturnType = new GenericType<ClickwrapAgreementsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionResponse getClickwrapVersion(String accountId, String clickwrapId, String versionId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapVersion");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapVersion");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling getClickwrapVersion");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionId\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionResponse> localVarReturnType = new GenericType<ClickwrapVersionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapAgreementsResponse getClickwrapVersionAgreements(String accountId, String clickwrapId, String versionId) throws ApiException {
        return this.getClickwrapVersionAgreements(accountId, clickwrapId, versionId, null);
    }

    public ClickwrapAgreementsResponse getClickwrapVersionAgreements(String accountId, String clickwrapId, String versionId, GetClickwrapVersionAgreementsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapVersionAgreements");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapVersionAgreements");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling getClickwrapVersionAgreements");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionId\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_user_id", options.clientUserId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_number", options.pageNumber));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapAgreementsResponse> localVarReturnType = new GenericType<ClickwrapAgreementsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapAgreementsResponse getClickwrapVersionAgreementsByNumber(String accountId, String clickwrapId, String versionNumber) throws ApiException {
        return this.getClickwrapVersionAgreementsByNumber(accountId, clickwrapId, versionNumber, null);
    }

    public ClickwrapAgreementsResponse getClickwrapVersionAgreementsByNumber(String accountId, String clickwrapId, String versionNumber, GetClickwrapVersionAgreementsByNumberOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapVersionAgreementsByNumber");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapVersionAgreementsByNumber");
        }
        if (versionNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'versionNumber' when calling getClickwrapVersionAgreementsByNumber");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionNumber}/users".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionNumber\\}", this.apiClient.escapeString(versionNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_user_id", options.clientUserId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_number", options.pageNumber));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapAgreementsResponse> localVarReturnType = new GenericType<ClickwrapAgreementsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionResponse getClickwrapVersionByNumber(String accountId, String clickwrapId, String versionNumber) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapVersionByNumber");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapVersionByNumber");
        }
        if (versionNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'versionNumber' when calling getClickwrapVersionByNumber");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionNumber}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionNumber\\}", this.apiClient.escapeString(versionNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionResponse> localVarReturnType = new GenericType<ClickwrapVersionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionsPagedResponse getClickwrapVersions(String accountId, String clickwrapId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwrapVersions");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling getClickwrapVersions");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionsPagedResponse> localVarReturnType = new GenericType<ClickwrapVersionsPagedResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionsResponse getClickwraps(String accountId) throws ApiException {
        return this.getClickwraps(accountId, null);
    }

    public ClickwrapVersionsResponse getClickwraps(String accountId, GetClickwrapsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getClickwraps");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from_date", options.fromDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ownerUserId", options.ownerUserId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_number", options.pageNumber));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to_date", options.toDate));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionsResponse> localVarReturnType = new GenericType<ClickwrapVersionsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ServiceInformation getServiceInformation() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/service_information";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ServiceInformation> localVarReturnType = new GenericType<ServiceInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionSummaryResponse updateClickwrap(String accountId, String clickwrapId, ClickwrapTransferRequest clickwrapTransferRequest) throws ApiException {
        ClickwrapTransferRequest localVarPostBody = clickwrapTransferRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateClickwrap");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling updateClickwrap");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionSummaryResponse updateClickwrapVersion(String accountId, String clickwrapId, String versionId, ClickwrapRequest clickwrapRequest) throws ApiException {
        ClickwrapRequest localVarPostBody = clickwrapRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateClickwrapVersion");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling updateClickwrapVersion");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling updateClickwrapVersion");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionId\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ClickwrapVersionSummaryResponse updateClickwrapVersionByNumber(String accountId, String clickwrapId, String versionNumber, ClickwrapRequest clickwrapRequest) throws ApiException {
        ClickwrapRequest localVarPostBody = clickwrapRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateClickwrapVersionByNumber");
        }
        if (clickwrapId == null) {
            throw new ApiException(400, "Missing the required parameter 'clickwrapId' when calling updateClickwrapVersionByNumber");
        }
        if (versionNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'versionNumber' when calling updateClickwrapVersionByNumber");
        }
        String localVarPath = "/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionNumber}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{clickwrapId\\}", this.apiClient.escapeString(clickwrapId.toString())).replaceAll("\\{versionNumber\\}", this.apiClient.escapeString(versionNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ClickwrapVersionSummaryResponse> localVarReturnType = new GenericType<ClickwrapVersionSummaryResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public class GetClickwrapsOptions {
        private String fromDate = null;
        private String ownerUserId = null;
        private String pageNumber = null;
        private String status = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setOwnerUserId(String ownerUserId) {
            this.ownerUserId = ownerUserId;
        }

        public String getOwnerUserId() {
            return this.ownerUserId;
        }

        public void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        public String getPageNumber() {
            return this.pageNumber;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class GetClickwrapVersionAgreementsByNumberOptions {
        private String clientUserId = null;
        private String fromDate = null;
        private String pageNumber = null;
        private String status = null;
        private String toDate = null;

        public void setClientUserId(String clientUserId) {
            this.clientUserId = clientUserId;
        }

        public String getClientUserId() {
            return this.clientUserId;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        public String getPageNumber() {
            return this.pageNumber;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class GetClickwrapVersionAgreementsOptions {
        private String clientUserId = null;
        private String fromDate = null;
        private String pageNumber = null;
        private String status = null;
        private String toDate = null;

        public void setClientUserId(String clientUserId) {
            this.clientUserId = clientUserId;
        }

        public String getClientUserId() {
            return this.clientUserId;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        public String getPageNumber() {
            return this.pageNumber;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class GetClickwrapAgreementsOptions {
        private String clientUserId = null;
        private String fromDate = null;
        private String pageNumber = null;
        private String status = null;
        private String toDate = null;

        public void setClientUserId(String clientUserId) {
            this.clientUserId = clientUserId;
        }

        public String getClientUserId() {
            return this.clientUserId;
        }

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        public String getPageNumber() {
            return this.pageNumber;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class DeleteClickwrapsOptions {
        private String clickwrapIds = null;

        public void setClickwrapIds(String clickwrapIds) {
            this.clickwrapIds = clickwrapIds;
        }

        public String getClickwrapIds() {
            return this.clickwrapIds;
        }
    }

    public class DeleteClickwrapVersionsOptions {
        private String clickwrapVersionIds = null;

        public void setClickwrapVersionIds(String clickwrapVersionIds) {
            this.clickwrapVersionIds = clickwrapVersionIds;
        }

        public String getClickwrapVersionIds() {
            return this.clickwrapVersionIds;
        }
    }

    public class DeleteClickwrapOptions {
        private String versions = null;

        public void setVersions(String versions) {
            this.versions = versions;
        }

        public String getVersions() {
            return this.versions;
        }
    }
}

