/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;

public class IPAddressValidator {
    protected Optional<InetAddress> asInetAddress(String subject) {
        try {
            if (InetAddresses.isInetAddress((String)subject)) {
                return Optional.of((Object)InetAddresses.forString((String)subject));
            }
            return Optional.absent();
        }
        catch (NullPointerException e) {
            return Optional.absent();
        }
    }

    protected Optional<String> checkIpAddress(String subject, int expectedLength, String failureFormat) {
        Optional inetAddressOptional = this.asInetAddress(subject);
        if (inetAddressOptional.isPresent() && ((InetAddress)inetAddressOptional.get()).getAddress().length != expectedLength) {
            inetAddressOptional = Optional.absent();
        }
        return (Optional)inetAddressOptional.transform((Function)new Function<InetAddress, Optional<String>>(){

            public Optional<String> apply(InetAddress input) {
                return IPAddressValidator.this.emptyString();
            }
        }).or((Object)Optional.of((Object)String.format(failureFormat, subject)));
    }

    private Optional<String> emptyString() {
        return Optional.absent();
    }
}

