/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.everit.json.schema.Schema;
import org.json.JSONArray;
import org.json.JSONObject;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 6192047123024651924L;
    private final StringBuilder pointerToViolation;
    private final transient Schema violatedSchema;
    private final List<ValidationException> causingExceptions;
    private final String keyword;

    private static int getViolationCount(List<ValidationException> causes) {
        int causeCount = 0;
        for (ValidationException exception : causes) {
            causeCount += exception.getViolationCount();
        }
        return Math.max(1, causeCount);
    }

    private static List<String> getAllMessages(List<ValidationException> causes) {
        ArrayList messages = Lists.newArrayList();
        for (ValidationException cause : causes) {
            if (cause.getCausingExceptions().isEmpty()) {
                messages.add(cause.getMessage());
                continue;
            }
            messages.addAll(ValidationException.getAllMessages(cause.getCausingExceptions()));
        }
        return messages;
    }

    public static void throwFor(Schema rootFailingSchema, List<ValidationException> failures) {
        int failureCount = failures.size();
        if (failureCount == 0) {
            return;
        }
        if (failureCount == 1) {
            throw failures.get(0);
        }
        throw new ValidationException(rootFailingSchema, new ArrayList<ValidationException>(failures));
    }

    @Deprecated
    public ValidationException(Class<?> expectedType, Object actualValue) {
        this(null, expectedType, actualValue);
    }

    public ValidationException(Schema violatedSchema, Class<?> expectedType, Object actualValue) {
        this(violatedSchema, expectedType, actualValue, "type");
    }

    public ValidationException(Schema violatedSchema, Class<?> expectedType, Object actualValue, String keyword) {
        this(violatedSchema, new StringBuilder("#"), "expected type: " + expectedType.getSimpleName() + ", found: " + (actualValue == null ? "null" : actualValue.getClass().getSimpleName()), Collections.emptyList(), keyword);
    }

    private ValidationException(Schema rootFailingSchema, List<ValidationException> causingExceptions) {
        this(rootFailingSchema, new StringBuilder("#"), ValidationException.getViolationCount(causingExceptions) + " schema violations found", causingExceptions);
    }

    @Deprecated
    public ValidationException(Schema violatedSchema, String message) {
        this(violatedSchema, new StringBuilder("#"), message, Collections.emptyList());
    }

    public ValidationException(Schema violatedSchema, String message, String keyword) {
        this(violatedSchema, new StringBuilder("#"), message, Collections.emptyList(), keyword);
    }

    @Deprecated
    ValidationException(Schema violatedSchema, StringBuilder pointerToViolation, String message, List<ValidationException> causingExceptions) {
        this(violatedSchema, pointerToViolation, message, causingExceptions, null);
    }

    ValidationException(Schema violatedSchema, StringBuilder pointerToViolation, String message, List<ValidationException> causingExceptions, String keyword) {
        super(message);
        this.violatedSchema = violatedSchema;
        this.pointerToViolation = pointerToViolation;
        this.causingExceptions = Collections.unmodifiableList(causingExceptions);
        this.keyword = keyword;
    }

    @Deprecated
    public ValidationException(String message) {
        this((Schema)null, new StringBuilder("#"), message, Collections.emptyList());
    }

    private ValidationException(StringBuilder pointerToViolation, Schema violatedSchema, String message, List<ValidationException> causingExceptions, String keyword) {
        this(violatedSchema, pointerToViolation, message, causingExceptions, keyword);
    }

    @Deprecated
    public ValidationException(Schema violatedSchema, String message, List<ValidationException> causingExceptions) {
        this(violatedSchema, new StringBuilder("#"), message, causingExceptions);
    }

    private String escapeFragment(String fragment) {
        return fragment.replace("~", "~0").replace("/", "~1");
    }

    public List<ValidationException> getCausingExceptions() {
        return this.causingExceptions;
    }

    public List<String> getAllMessages() {
        if (this.causingExceptions.isEmpty()) {
            return Collections.singletonList(this.getMessage());
        }
        return ValidationException.getAllMessages(this.causingExceptions);
    }

    @Override
    public String getMessage() {
        return this.getPointerToViolation() + ": " + super.getMessage();
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    public String getPointerToViolation() {
        if (this.pointerToViolation == null) {
            return null;
        }
        return this.pointerToViolation.toString();
    }

    public Schema getViolatedSchema() {
        return this.violatedSchema;
    }

    public ValidationException prepend(String fragment) {
        return this.prepend(fragment, this.violatedSchema);
    }

    public ValidationException prepend(String fragment, Schema violatedSchema) {
        final String escapedFragment = this.escapeFragment(Objects.requireNonNull(fragment, "fragment cannot be null"));
        StringBuilder newPointer = this.pointerToViolation.insert(1, '/').insert(2, escapedFragment);
        ImmutableList prependedCausingExceptions = FluentIterable.from(this.causingExceptions).transform((Function)new Function<ValidationException, ValidationException>(){

            public ValidationException apply(ValidationException exc) {
                return exc.prepend(escapedFragment);
            }
        }).toList();
        return new ValidationException(newPointer, violatedSchema, super.getMessage(), (List<ValidationException>)prependedCausingExceptions, this.keyword);
    }

    public int getViolationCount() {
        return ValidationException.getViolationCount(this.causingExceptions);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public JSONObject toJSON() {
        JSONObject rval = new JSONObject();
        rval.put("keyword", (Object)this.keyword);
        if (this.pointerToViolation == null) {
            rval.put("pointerToViolation", JSONObject.NULL);
        } else {
            rval.put("pointerToViolation", (Object)this.getPointerToViolation());
        }
        rval.put("message", (Object)super.getMessage());
        ImmutableList causeJsons = FluentIterable.from(this.causingExceptions).transform((Function)new Function<ValidationException, JSONObject>(){

            public JSONObject apply(ValidationException input) {
                return input.toJSON();
            }
        }).toList();
        rval.put("causingExceptions", (Object)new JSONArray((Collection)causeJsons));
        return rval;
    }
}

