/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import java.util.List;

public class SchemaException
extends RuntimeException {
    private static final long serialVersionUID = 5987489689035036987L;

    private static Object typeOfValue(Object actualValue) {
        return actualValue == null ? "null" : actualValue.getClass().getSimpleName();
    }

    private static String joinClassNames(List<Class<?>> expectedTypes) {
        return Joiner.on((String)", ").join((Iterable)FluentIterable.from(expectedTypes).transform(new Function<Class<?>, String>(){

            public String apply(Class<?> input) {
                return input.getSimpleName();
            }
        }));
    }

    public SchemaException(String message) {
        super(message);
    }

    public SchemaException(String key, Class<?> expectedType, Object actualValue) {
        this(String.format("key %s : expected type: %s , found : %s", key, expectedType.getSimpleName(), SchemaException.typeOfValue(actualValue)));
    }

    public SchemaException(String key, List<Class<?>> expectedTypes, Object actualValue) {
        this(String.format("key %s: expected type is one of %s, found: %s", key, SchemaException.joinClassNames(expectedTypes), SchemaException.typeOfValue(actualValue)));
    }

    public SchemaException(String message, Throwable cause) {
        super(message, cause);
    }
}

