/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui.base;

import com.github.gwtbootstrap.client.ui.base.Style;
import com.google.gwt.user.client.ui.UIObject;

public class StyleHelper {
    public static <T extends UIObject> void addStyle(T widget, Style style) {
        if (style == null || style.get().isEmpty()) {
            return;
        }
        widget.addStyleName(style.get());
    }

    public static <T extends UIObject> void setStyle(T widget, Style style) {
        widget.setStyleName(style.get());
    }

    public static <T extends UIObject> void removeStyle(T widget, Style style) {
        String styleString = style.get();
        if (!styleString.isEmpty()) {
            widget.removeStyleName(styleString);
        }
    }

    public static <S extends Enum<S>> void changeStyle(UIObject widget, S style, Class<S> styleEnums) {
        assert (styleEnums != null) : "styleEnums should not be null.";
        StyleHelper.changeStyle((UIObject)widget, (Style)((Style)((Object)style)), (Style[])((Style[])styleEnums.getEnumConstants()));
    }

    public static <S extends Style> void changeStyle(UIObject widget, S style, S[] otherStyles) {
        assert (widget != null && otherStyles != null) : "any args should not be null.";
        for (S s : otherStyles) {
            StyleHelper.removeStyle(widget, s);
        }
        StyleHelper.addStyle(widget, style);
    }
}

