/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui.base;

import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.config.ColumnSizeConfigurator;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.UIObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SizeHelper {
    private static List<SizeSpan> SIZE_LIST;
    private static final ColumnSizeConfigurator CONFIGURATOR;

    public static void setSize(UIObject widget, int size) {
        StyleHelper.changeStyle((UIObject)widget, (Style)new SizeSpan(size), (Style[])SIZE_LIST.toArray(new SizeSpan[SIZE_LIST.size()]));
    }

    static {
        CONFIGURATOR = (ColumnSizeConfigurator)GWT.create(ColumnSizeConfigurator.class);
        ArrayList<SizeSpan> list = new ArrayList<SizeSpan>();
        for (int i = CONFIGURATOR.getMinimumSpanSize(); i <= CONFIGURATOR.getMaximumSpanSize(); ++i) {
            list.add(new SizeSpan(i));
        }
        SIZE_LIST = Collections.unmodifiableList(list);
    }

    private static class SizeSpan
    implements Style {
        private static final ColumnSizeConfigurator CONFIGURATOR = (ColumnSizeConfigurator)GWT.create(ColumnSizeConfigurator.class);
        private static final String SIZE_ERROR_MESSAGE = "The size of the Column has to be between " + CONFIGURATOR.getMinimumSpanSize() + " and " + CONFIGURATOR.getMaximumSpanSize() + "!";
        private final int size;

        private SizeSpan(int size) {
            if (size < CONFIGURATOR.getMinimumSpanSize()) {
                throw new IllegalArgumentException(SIZE_ERROR_MESSAGE);
            }
            if (size > CONFIGURATOR.getMaximumSpanSize()) {
                throw new IllegalArgumentException(SIZE_ERROR_MESSAGE);
            }
            this.size = size;
        }

        @Override
        public String get() {
            return "span" + this.size;
        }
    }
}

