/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui.base;

import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.base.ComplexWidget;
import com.github.gwtbootstrap.client.ui.base.HasIcon;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.base.UnorderedList;
import com.github.gwtbootstrap.client.ui.constants.Alignment;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;

public abstract class DropdownBase
extends ComplexWidget
implements HasChangeHandlers,
HasClickHandlers,
HasWidgets,
HasText,
HasIcon {
    private UnorderedList menu = new UnorderedList();
    protected IconAnchor trigger;
    private NavLink link;
    private NavLinkClickHandler handler = new NavLinkClickHandler();
    private boolean dropup;

    public DropdownBase(String type) {
        super(type);
        this.createAndAddTrigger();
        this.menu.setStyleName("dropdown-menu");
        super.add((Widget)this.menu);
    }

    private void createAndAddTrigger() {
        this.trigger = this.createTrigger();
        if (this.trigger != null) {
            this.trigger.addStyleName("dropdown-toggle");
            this.trigger.getElement().setAttribute("data-toggle", "dropdown");
            super.add((Widget)this.trigger);
        }
    }

    public void setText(String text) {
        this.trigger.setText(text);
    }

    public String getText() {
        return this.trigger.getText();
    }

    public IconAnchor getTriggerWidget() {
        return this.trigger;
    }

    public UnorderedList getMenuWiget() {
        return this.menu;
    }

    protected abstract IconAnchor createTrigger();

    public void setDropup(boolean dropup) {
        this.dropup = dropup;
        if (dropup) {
            this.addStyleName("dropup");
        } else {
            this.removeStyleName("dropup");
        }
    }

    public boolean isDropup() {
        return this.dropup;
    }

    protected void onLoad() {
        super.onLoad();
        if (this.trigger != null) {
            this.configure(this.trigger.getElement());
        }
    }

    @Override
    public void add(Widget widget) {
        this.menu.add(widget);
        if (widget instanceof NavLink) {
            ((NavLink)widget).addClickHandler(this.handler);
        }
    }

    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler((EventHandler)handler, ChangeEvent.getType());
    }

    protected void addWidget(Widget widget) {
        super.add(widget);
    }

    private void configure(Element e) {
    }

    public void setRightDropdown(boolean rightDropdown) {
        this.menu.setStyleName(Alignment.RIGHT.get(), rightDropdown);
    }

    public NavLink getLastSelectedNavLink() {
        return this.link;
    }

    public void clear() {
        this.menu.clear();
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.trigger.addClickHandler(handler);
    }

    @UiChild(tagname="customTrigger", limit=1)
    public void addCustomTrigger(Widget w) {
        this.trigger.insert(w, 0);
    }

    private class NavLinkClickHandler
    implements ClickHandler {
        private NavLinkClickHandler() {
        }

        public void onClick(ClickEvent event) {
            try {
                IconAnchor iconAnchor = (IconAnchor)event.getSource();
                DropdownBase.this.link = (NavLink)iconAnchor.getParent();
            }
            catch (Exception e) {
                GWT.log((String)e.getMessage(), (Throwable)e);
            }
            DomEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)DropdownBase.this);
        }
    }
}

