/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui.base;

import com.github.gwtbootstrap.client.ui.Close;
import com.github.gwtbootstrap.client.ui.base.HasType;
import com.github.gwtbootstrap.client.ui.base.HtmlWidget;
import com.github.gwtbootstrap.client.ui.base.IsAnimated;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.AlertType;
import com.github.gwtbootstrap.client.ui.constants.DismissType;
import com.github.gwtbootstrap.client.ui.event.ClosedEvent;
import com.github.gwtbootstrap.client.ui.event.ClosedHandler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public abstract class AlertBase
extends HtmlWidget
implements IsAnimated,
com.github.gwtbootstrap.client.ui.event.HasCloseHandlers<AlertBase>,
HasType<AlertType> {
    private Close close;
    private HTMLPanel closeReplacement = new HTMLPanel("span", "");
    private HTMLPanel headingContainer = new HTMLPanel("span", "");
    private HTMLPanel container;
    private boolean fade;
    private boolean hasClose;

    public AlertBase() {
        this("", true);
    }

    public AlertBase(String html) {
        this(html, true);
    }

    public AlertBase(String html, boolean hasClose) {
        super("div", "");
        super.add((Widget)this.closeReplacement);
        super.add((Widget)this.headingContainer);
        this.container = new HTMLPanel("span", html);
        super.add((Widget)this.container);
        super.setStyleName("alert");
        this.setClose(hasClose);
    }

    public AlertBase(AlertType type) {
        this();
        this.setType(type);
    }

    public void setClose(boolean hasClose) {
        this.hasClose = hasClose;
        if (!this.isAttached()) {
            return;
        }
        if (hasClose) {
            if (this.close == null) {
                this.close = new Close(DismissType.ALERT);
                this.getElement().replaceChild((Node)this.close.getElement(), (Node)this.closeReplacement.getElement());
            }
        } else if (this.close != null) {
            this.getElement().replaceChild((Node)this.closeReplacement.getElement(), (Node)this.close.getElement());
            this.close = null;
        }
    }

    protected void onAttach() {
        super.onAttach();
        this.setClose(this.hasClose);
        this.configure(this.getElement());
        this.setHandlerFunctions(this.getElement());
    }

    public boolean hasClose() {
        return this.hasClose;
    }

    protected HasWidgets getHeadingContainer() {
        return this.headingContainer;
    }

    protected void onClose() {
        CloseEvent.fire((HasCloseHandlers)this, (Object)this);
    }

    protected void onClosed() {
        ClosedEvent.fire(this, this);
    }

    @Override
    public void setType(AlertType type) {
        StyleHelper.changeStyle((UIObject)this, type, AlertType.class);
    }

    public void setHeading(String text) {
        this.headingContainer.clear();
        this.headingContainer.add((Widget)new HTMLPanel("span", text));
    }

    @Override
    public void setAnimation(boolean animated) {
        this.fade = animated;
        this.setFade();
    }

    @Override
    public boolean getAnimation() {
        return this.fade;
    }

    public void clear() {
        this.container.clear();
    }

    private void setFade() {
        if (this.fade) {
            this.addStyleName("fade");
            this.addStyleName("in");
        } else {
            this.removeStyleName("fade");
            this.removeStyleName("in");
        }
    }

    public String getText() {
        return this.container.getElement().getInnerText();
    }

    public void setText(String text) {
        this.setHTML(SafeHtmlUtils.htmlEscape((String)text));
    }

    public String getHTML() {
        return this.container.getElement().getInnerHTML();
    }

    public void setHTML(String html) {
        this.container.clear();
        this.container.add((Widget)new HTMLPanel("span", html));
    }

    public void close() {
        this.close(this.getElement());
    }

    public HandlerRegistration addCloseHandler(CloseHandler<AlertBase> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    @Override
    public HandlerRegistration addClosedHandler(ClosedHandler<AlertBase> handler) {
        return this.addHandler(handler, ClosedEvent.getType());
    }

    private void setHandlerFunctions(Element e) {
    }

    private void configure(Element e) {
    }

    private void close(Element e) {
    }
}

