/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Tooltip;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.constants.Placement;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.cellview.client.AbstractPager;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;

public class SimplePager
extends AbstractPager {
    private static final int DEFAULT_FAST_FORWARD_ROWS = 100;
    private static Resources DEFAULT_RESOURCES;
    private final int tooltipDelay = 1000;
    private final Placement tooltipPlacement = Placement.BOTTOM;
    private final Button fastForward;
    private final Tooltip fastForwardTooltip;
    private int fastForwardRows;
    private final Button firstPage;
    private final Tooltip firstPageTooltip;
    private final HTML label = new HTML();
    private final Button lastPage;
    private final Button nextPage;
    private final Button prevPage;
    private final Tooltip lastPageTooltip;
    private final Tooltip nextPageTooltip;
    private final Tooltip prevPageTooltip;
    private final Resources resources;
    private final SimplePager.Style style;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public SimplePager() {
        this(TextLocation.CENTER);
    }

    @UiConstructor
    public SimplePager(TextLocation location) {
        this(location, SimplePager.getDefaultResources(), true, 100, false);
    }

    public SimplePager(TextLocation location, boolean showFastForwardButton, boolean showLastPageButton) {
        this(location, showFastForwardButton, 100, showLastPageButton);
    }

    public SimplePager(TextLocation location, boolean showFastForwardButton, int fastForwardRows, boolean showLastPageButton) {
        this(location, SimplePager.getDefaultResources(), showFastForwardButton, fastForwardRows, showLastPageButton);
    }

    public SimplePager(TextLocation location, Resources resources, boolean showFastForwardButton, int fastForwardRows, boolean showLastPageButton, ImageButtonsConstants imageButtonConstants) {
        this.resources = resources;
        this.fastForwardRows = fastForwardRows;
        this.style = this.resources.simplePagerStyle();
        this.style.ensureInjected();
        this.firstPage = new Button();
        this.firstPage.setType(ButtonType.LINK);
        this.firstPage.setIcon(IconType.FAST_BACKWARD);
        this.firstPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimplePager.this.firstPage();
            }
        });
        this.firstPageTooltip = new Tooltip(imageButtonConstants.firstPage());
        this.firstPageTooltip.setWidget((Widget)this.firstPage);
        this.firstPageTooltip.setPlacement(this.tooltipPlacement);
        this.firstPageTooltip.setShowDelay(1000);
        this.nextPage = new Button();
        this.nextPage.setType(ButtonType.LINK);
        this.nextPage.setIcon(IconType.STEP_FORWARD);
        this.nextPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimplePager.this.nextPage();
            }
        });
        this.nextPageTooltip = new Tooltip(imageButtonConstants.nextPage());
        this.nextPageTooltip.setWidget((Widget)this.nextPage);
        this.nextPageTooltip.setPlacement(this.tooltipPlacement);
        this.nextPageTooltip.setShowDelay(1000);
        this.prevPage = new Button();
        this.prevPage.setType(ButtonType.LINK);
        this.prevPage.setIcon(IconType.STEP_BACKWARD);
        this.prevPage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimplePager.this.previousPage();
            }
        });
        this.prevPageTooltip = new Tooltip(imageButtonConstants.prevPage());
        this.prevPageTooltip.setWidget((Widget)this.prevPage);
        this.prevPageTooltip.setPlacement(this.tooltipPlacement);
        this.prevPageTooltip.setShowDelay(1000);
        if (showLastPageButton) {
            this.lastPage = new Button();
            this.lastPage.setType(ButtonType.LINK);
            this.lastPage.setIcon(IconType.FAST_FORWARD);
            this.lastPage.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SimplePager.this.lastPage();
                }
            });
            this.lastPageTooltip = new Tooltip(imageButtonConstants.lastPage());
            this.lastPageTooltip.setWidget((Widget)this.lastPage);
            this.lastPageTooltip.setPlacement(this.tooltipPlacement);
            this.lastPageTooltip.setShowDelay(1000);
        } else {
            this.lastPage = null;
            this.lastPageTooltip = null;
        }
        if (showFastForwardButton) {
            this.fastForward = new Button();
            this.fastForward.setType(ButtonType.LINK);
            this.fastForward.setIcon(IconType.FORWARD);
            this.fastForward.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SimplePager.this.setPage(SimplePager.this.getPage() + SimplePager.this.getFastForwardPages());
                }
            });
            this.fastForwardTooltip = new Tooltip(imageButtonConstants.fastForward());
            this.fastForwardTooltip.setWidget((Widget)this.fastForward);
            this.fastForwardTooltip.setPlacement(this.tooltipPlacement);
            this.fastForwardTooltip.setShowDelay(1000);
        } else {
            this.fastForward = null;
            this.fastForwardTooltip = null;
        }
        HorizontalPanel layout = new HorizontalPanel();
        layout.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.initWidget((Widget)layout);
        if (location == TextLocation.LEFT) {
            layout.add((Widget)this.label);
        }
        layout.add((Widget)this.firstPage);
        layout.add((IsWidget)this.firstPageTooltip);
        layout.add((Widget)this.prevPage);
        layout.add((IsWidget)this.prevPageTooltip);
        if (location == TextLocation.CENTER) {
            layout.add((Widget)this.label);
        }
        layout.add((Widget)this.nextPage);
        layout.add((IsWidget)this.nextPageTooltip);
        if (showFastForwardButton) {
            layout.add((Widget)this.fastForward);
            layout.add((IsWidget)this.fastForwardTooltip);
        }
        if (showLastPageButton) {
            layout.add((Widget)this.lastPage);
            layout.add((IsWidget)this.lastPageTooltip);
        }
        if (location == TextLocation.RIGHT) {
            layout.add((Widget)this.label);
        }
        this.firstPage.getElement().getParentElement().addClassName(this.style.button());
        this.prevPage.getElement().getParentElement().addClassName(this.style.button());
        this.label.getElement().getParentElement().addClassName(this.style.pageDetails());
        this.nextPage.getElement().getParentElement().addClassName(this.style.button());
        if (showFastForwardButton) {
            this.fastForward.getElement().getParentElement().addClassName(this.style.button());
        }
        if (showLastPageButton) {
            this.lastPage.getElement().getParentElement().addClassName(this.style.button());
        }
        this.setDisplay(null);
    }

    public SimplePager(TextLocation location, Resources resources, boolean showFastForwardButton, int fastForwardRows, boolean showLastPageButton) {
        this(location, resources, showFastForwardButton, fastForwardRows, showLastPageButton, (ImageButtonsConstants)GWT.create(ImageButtonsConstants.class));
    }

    public void firstPage() {
        super.firstPage();
    }

    public int getPage() {
        return super.getPage();
    }

    public int getPageCount() {
        return super.getPageCount();
    }

    public boolean hasNextPage() {
        return super.hasNextPage();
    }

    public boolean hasNextPages(int pages) {
        return super.hasNextPages(pages);
    }

    public boolean hasPage(int index) {
        return super.hasPage(index);
    }

    public boolean hasPreviousPage() {
        return super.hasPreviousPage();
    }

    public boolean hasPreviousPages(int pages) {
        return super.hasPreviousPages(pages);
    }

    public void lastPage() {
        super.lastPage();
    }

    public void lastPageStart() {
        super.lastPageStart();
    }

    public void nextPage() {
        super.nextPage();
    }

    public void previousPage() {
        super.previousPage();
    }

    public void setDisplay(HasRows display) {
        boolean disableButtons = display == null;
        this.setFastForwardDisabled(disableButtons);
        this.setNextPageButtonsDisabled(disableButtons);
        this.setPrevPageButtonsDisabled(disableButtons);
        super.setDisplay(display);
    }

    public void setPage(int index) {
        super.setPage(index);
    }

    public void setPageSize(int pageSize) {
        super.setPageSize(pageSize);
    }

    public void setPageStart(int index) {
        super.setPageStart(index);
    }

    public void startLoading() {
        this.getDisplay().setRowCount(0, true);
        this.label.setHTML("");
    }

    protected String createText() {
        NumberFormat formatter = NumberFormat.getFormat((String)"#,###");
        HasRows display = this.getDisplay();
        Range range = display.getVisibleRange();
        int pageStart = range.getStart() + 1;
        int pageSize = range.getLength();
        int dataSize = display.getRowCount();
        int endIndex = Math.min(dataSize, pageStart + pageSize - 1);
        endIndex = Math.max(pageStart, endIndex);
        boolean exact = display.isRowCountExact();
        return formatter.format((double)pageStart) + "-" + formatter.format((double)endIndex) + (exact ? " of " : " of over ") + formatter.format((double)dataSize);
    }

    protected void onRangeOrRowCountChanged() {
        HasRows display = this.getDisplay();
        this.label.setText(this.createText());
        this.setPrevPageButtonsDisabled(!this.hasPreviousPage());
        if (this.isRangeLimited() || !display.isRowCountExact()) {
            this.setNextPageButtonsDisabled(!this.hasNextPage());
            this.setFastForwardDisabled(!this.hasNextPages(this.getFastForwardPages()));
        }
    }

    boolean isNextButtonDisabled() {
        return !this.nextPage.isEnabled();
    }

    boolean isPreviousButtonDisabled() {
        return !this.prevPage.isEnabled();
    }

    private int getFastForwardPages() {
        int pageSize = this.getPageSize();
        return pageSize > 0 ? this.fastForwardRows / pageSize : 0;
    }

    public int getFastForwardRows() {
        return this.fastForwardRows;
    }

    public void setFastForwardRows(int fastForwardRows) {
        this.fastForwardRows = fastForwardRows;
    }

    private void setFastForwardDisabled(boolean disabled) {
        if (this.fastForward != null) {
            this.fastForward.setEnabled(!disabled);
            if (disabled) {
                this.fastForward.getElement().addClassName(this.style.disabledButton());
            } else {
                this.fastForward.getElement().removeClassName(this.style.disabledButton());
            }
        }
    }

    private void setNextPageButtonsDisabled(boolean disabled) {
        this.nextPage.setEnabled(!disabled);
        if (disabled) {
            this.nextPage.getElement().addClassName(this.style.disabledButton());
        } else {
            this.nextPage.getElement().removeClassName(this.style.disabledButton());
        }
        if (this.lastPage != null) {
            this.lastPage.setEnabled(!disabled);
            if (disabled) {
                this.lastPage.getElement().addClassName(this.style.disabledButton());
            } else {
                this.lastPage.getElement().removeClassName(this.style.disabledButton());
            }
        }
    }

    private void setPrevPageButtonsDisabled(boolean disabled) {
        this.firstPage.setEnabled(!disabled);
        this.prevPage.setEnabled(!disabled);
        if (disabled) {
            this.firstPage.getElement().addClassName(this.style.disabledButton());
            this.prevPage.getElement().addClassName(this.style.disabledButton());
        } else {
            this.firstPage.getElement().removeClassName(this.style.disabledButton());
            this.prevPage.getElement().removeClassName(this.style.disabledButton());
        }
    }

    public static enum TextLocation {
        CENTER,
        LEFT,
        RIGHT;

    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"GwtBootstrapSimplePager.css"})
        public SimplePager.Style simplePagerStyle();
    }

    @LocalizableResource.DefaultLocale(value="en_US")
    public static interface ImageButtonsConstants
    extends Constants {
        @Constants.DefaultStringValue(value="Fast forward")
        public String fastForward();

        @Constants.DefaultStringValue(value="First page")
        public String firstPage();

        @Constants.DefaultStringValue(value="Last page")
        public String lastPage();

        @Constants.DefaultStringValue(value="Next page")
        public String nextPage();

        @Constants.DefaultStringValue(value="Previous page")
        public String prevPage();
    }
}

