/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.HasAlternateSize;
import com.github.gwtbootstrap.client.ui.base.HasId;
import com.github.gwtbootstrap.client.ui.base.HasSize;
import com.github.gwtbootstrap.client.ui.base.HasStyle;
import com.github.gwtbootstrap.client.ui.base.IsResponsive;
import com.github.gwtbootstrap.client.ui.base.IsSearchQuery;
import com.github.gwtbootstrap.client.ui.base.ResponsiveHelper;
import com.github.gwtbootstrap.client.ui.base.SearchQueryStyleHelper;
import com.github.gwtbootstrap.client.ui.base.SizeHelper;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.AlternateSize;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.constants.Device;
import com.google.gwt.dom.client.Element;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class ListBox
extends com.google.gwt.user.client.ui.ListBox
implements HasSize,
HasAlternateSize,
IsSearchQuery,
HasId,
IsResponsive,
HasStyle,
HasEditorErrors<String> {
    private Widget controlGroup;
    private Widget errorLabel;

    public ListBox() {
        this.setStyleName("");
    }

    public ListBox(boolean isMultipleSelect) {
        super(isMultipleSelect);
        this.setStyleName("");
    }

    protected ListBox(Element element) {
        super(element);
        this.setStyleName("");
    }

    @Override
    public void setAlternateSize(AlternateSize size) {
        StyleHelper.changeStyle((UIObject)this, size, AlternateSize.class);
    }

    @Override
    public void setSize(int size) {
        SizeHelper.setSize((UIObject)this, size);
    }

    public String getValue() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return this.getValue(this.getSelectedIndex());
    }

    @Override
    public void setSearchQuery(boolean searchQuery) {
        SearchQueryStyleHelper.setSearchQuery((Widget)this, searchQuery);
    }

    @Override
    public boolean isSearchQuery() {
        return SearchQueryStyleHelper.isSearchQuery((Widget)this);
    }

    @Override
    public String getId() {
        return this.getElement().getId();
    }

    @Override
    public void setId(String id) {
        this.getElement().setId(id);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.removeStyleName("disabled");
        } else {
            this.addStyleName("disabled");
        }
    }

    public void setSelectedValue(String value) {
        if (value == null) {
            value = "";
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getValue(i).equals(value)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    @Override
    public void setShowOn(Device device) {
        ResponsiveHelper.setShowOn(this, device);
    }

    @Override
    public void setHideOn(Device device) {
        ResponsiveHelper.setHideOn(this, device);
    }

    @Override
    public void setStyle(Style style) {
        StyleHelper.setStyle(this, style);
    }

    @Override
    public void addStyle(Style style) {
        StyleHelper.addStyle(this, style);
    }

    @Override
    public void removeStyle(Style style) {
        StyleHelper.removeStyle(this, style);
    }

    public void showErrors(List<EditorError> errors) {
        ListBox decoratedWidget;
        ListBox listBox = decoratedWidget = this.controlGroup != null ? this.controlGroup : this;
        if (errors != null && !errors.isEmpty()) {
            StyleHelper.addStyle(decoratedWidget, ControlGroupType.ERROR);
            SafeHtmlBuilder sb = new SafeHtmlBuilder();
            for (EditorError error : errors) {
                if (error.getEditor() != this) continue;
                error.setConsumed(true);
                sb.appendEscaped(error.getMessage());
                sb.appendHtmlConstant("<br />");
            }
            this.setErrorLabelText(sb.toSafeHtml().asString());
        } else {
            StyleHelper.removeStyle(decoratedWidget, ControlGroupType.ERROR);
            this.setErrorLabelText("");
        }
    }

    public void setControlGroup(Widget controlGroup) {
        this.controlGroup = controlGroup;
    }

    public void setErrorLabel(Widget errorLabel) {
        this.errorLabel = errorLabel;
    }

    protected void setErrorLabelText(String errorMessage) {
        if (this.errorLabel != null) {
            this.errorLabel.getElement().setInnerHTML(errorMessage);
        }
    }
}

