/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.constants.Alignment;
import com.github.gwtbootstrap.client.ui.constants.IconFlip;
import com.github.gwtbootstrap.client.ui.constants.IconRotate;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;

public class IconCell
extends AbstractCell<Void> {
    private IconType iconType;
    private IconSize iconSize;
    private boolean light;
    private boolean muted;
    private boolean border;
    private boolean spin;
    private Alignment alignment;
    private IconRotate iconRotate;
    private IconFlip iconFlip;
    private String tooltip;

    public IconCell(IconType iconType) {
        this(iconType, IconSize.DEFAULT);
    }

    public IconCell(IconType iconType, IconSize iconSize) {
        super(new String[0]);
        this.iconType = iconType;
        this.iconSize = iconSize;
        this.light = false;
        this.muted = false;
        this.border = false;
        this.spin = false;
        this.alignment = Alignment.NONE;
        this.iconRotate = IconRotate.NONE;
        this.iconFlip = IconFlip.NONE;
    }

    public void render(Cell.Context context, Void value, SafeHtmlBuilder sb) {
        StringBuilder builder = new StringBuilder();
        builder.append("<i").append(this.tooltip == null ? "" : " title=\"" + this.tooltip + "\"").append(" class=\"").append(this.iconType.get()).append(" ").append(this.iconSize.get()).append(this.light ? " icon-light" : "").append(this.muted ? " icon-muted" : "").append(this.border ? " icon-border" : "").append(this.spin ? " icon-spin" : "");
        if (this.alignment == Alignment.LEFT) {
            builder.append(" pull-left");
        }
        if (this.alignment == Alignment.RIGHT) {
            builder.append(" pull-right");
        }
        if (this.iconRotate == IconRotate.ROTATE_90) {
            builder.append(" icon-rotate-90");
        }
        if (this.iconRotate == IconRotate.ROTATE_180) {
            builder.append(" icon-rotate-180");
        }
        if (this.iconRotate == IconRotate.ROTATE_270) {
            builder.append(" icon-rotate-270");
        }
        if (this.iconFlip == IconFlip.HORIZONTAL) {
            builder.append(" icon-flip-horizontal");
        }
        if (this.iconFlip == IconFlip.VERTICAL) {
            builder.append(" icon-flip-vertical");
        }
        builder.append("\"></i>");
        sb.appendHtmlConstant(builder.toString());
    }

    public IconType getIconType() {
        return this.iconType;
    }

    public void setIconType(IconType iconType) {
        this.iconType = iconType;
    }

    public IconSize getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(IconSize iconSize) {
        this.iconSize = iconSize;
    }

    public boolean isLight() {
        return this.light;
    }

    public void setLight(boolean light) {
        this.light = light;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public boolean isSpin() {
        return this.spin;
    }

    public void setSpin(boolean spin) {
        this.spin = spin;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public IconRotate getIconRotate() {
        return this.iconRotate;
    }

    public void setIconRotate(IconRotate iconRotate) {
        this.iconRotate = iconRotate;
    }

    public IconFlip getIconFlip() {
        return this.iconFlip;
    }

    public void setIconFlip(IconFlip iconFlip) {
        this.iconFlip = iconFlip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }
}

