/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.HasAlignment;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.Alignment;
import com.github.gwtbootstrap.client.ui.constants.BaseIconType;
import com.github.gwtbootstrap.client.ui.constants.IconFlip;
import com.github.gwtbootstrap.client.ui.constants.IconRotate;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class Icon
extends Widget
implements HasAlignment {
    private BaseIconType type;

    public Icon() {
        this.setElement(DOM.createElement((String)"i"));
    }

    @UiConstructor
    public Icon(IconType type) {
        this();
        this.setBaseType(type);
    }

    public void setType(IconType type) {
        this.setBaseType(type);
    }

    public void setBaseType(BaseIconType type) {
        if (this.type != null) {
            StyleHelper.removeStyle(this, this.type);
        }
        this.type = type;
        StyleHelper.addStyle(this, type);
    }

    public void setIconSize(IconSize size) {
        StyleHelper.changeStyle((UIObject)this, size, IconSize.class);
    }

    public void setSize(IconSize size) {
        this.setIconSize(size);
    }

    public IconType getIconType() {
        if (this.type instanceof IconType) {
            return (IconType)this.type;
        }
        return null;
    }

    public BaseIconType getBaseIconType() {
        return this.type;
    }

    public void setIcon(IconType type) {
        this.setBaseType(type);
    }

    public void setLight(boolean light) {
        this.classNameToggle(light, "icon-light");
    }

    public void setMuted(boolean muted) {
        this.classNameToggle(muted, "icon-muted");
    }

    public void setBorder(boolean border) {
        this.classNameToggle(border, "icon-border");
    }

    public void setStackBase(boolean stackBase) {
        this.classNameToggle(stackBase, "icon-stack-base");
    }

    public void setSpin(boolean spin) {
        this.classNameToggle(spin, "icon-spin");
    }

    @Override
    public void setAlignment(Alignment alignment) {
        this.getElement().removeClassName(Alignment.LEFT.get());
        this.getElement().removeClassName(Alignment.RIGHT.get());
        if (alignment == null || alignment == Alignment.NONE) {
            return;
        }
        this.getElement().addClassName(alignment.get());
    }

    public void setRotate(IconRotate iconRotate) {
        this.getElement().removeClassName(IconRotate.ROTATE_90.get());
        this.getElement().removeClassName(IconRotate.ROTATE_180.get());
        this.getElement().removeClassName(IconRotate.ROTATE_270.get());
        if (iconRotate == null || iconRotate == IconRotate.NONE) {
            return;
        }
        this.getElement().addClassName(iconRotate.get());
    }

    public void setFlip(IconFlip iconFlip) {
        this.getElement().removeClassName(IconFlip.HORIZONTAL.get());
        this.getElement().removeClassName(IconFlip.VERTICAL.get());
        if (iconFlip == null || iconFlip == IconFlip.NONE) {
            return;
        }
        this.getElement().addClassName(iconFlip.get());
    }

    private void classNameToggle(boolean value, String className) {
        if (value) {
            this.getElement().addClassName(className);
        } else {
            this.getElement().removeClassName(className);
        }
    }
}

