/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.DivWidget;
import com.github.gwtbootstrap.client.ui.base.HasSize;
import com.github.gwtbootstrap.client.ui.base.SizeHelper;
import com.github.gwtbootstrap.client.ui.config.ColumnSizeConfigurator;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class Column
extends DivWidget
implements HasSize {
    private static final ColumnSizeConfigurator CONFIGURATOR = (ColumnSizeConfigurator)GWT.create(ColumnSizeConfigurator.class);
    private static final String OFFSET_ERROR_MESSAGE = "The offset of the Column has to be between " + CONFIGURATOR.getMinimumOffsetSize() + " and " + CONFIGURATOR.getMaximumOffsetSize() + "!";

    @UiConstructor
    public Column(int size) {
        this.setSize(size);
    }

    public Column(int size, int offset) {
        this(size);
        this.setOffset(offset);
    }

    public Column(int size, int offset, Widget ... widgets) {
        this(size, offset);
        this.add(widgets);
    }

    public Column(int size, Widget ... widgets) {
        this(size);
        this.add(widgets);
    }

    @Override
    public void setSize(int size) {
        SizeHelper.setSize((UIObject)this, size);
    }

    public void setOffset(int offset) {
        if (offset < CONFIGURATOR.getMinimumOffsetSize()) {
            throw new IllegalArgumentException(OFFSET_ERROR_MESSAGE);
        }
        if (offset > CONFIGURATOR.getMaximumOffsetSize()) {
            throw new IllegalArgumentException(OFFSET_ERROR_MESSAGE);
        }
        this.addStyleName("offset" + offset);
    }

    public void add(Widget ... widgets) {
        for (Widget widget : widgets) {
            this.add(widget);
        }
    }
}

