/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.HasVisibility;
import com.github.gwtbootstrap.client.ui.base.MarkupWidget;
import com.github.gwtbootstrap.client.ui.constants.VisibilityChange;
import com.github.gwtbootstrap.client.ui.event.HasVisibleHandlers;
import com.github.gwtbootstrap.client.ui.event.HiddenEvent;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.github.gwtbootstrap.client.ui.event.HideEvent;
import com.github.gwtbootstrap.client.ui.event.HideHandler;
import com.github.gwtbootstrap.client.ui.event.ShowEvent;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.github.gwtbootstrap.client.ui.event.ShownEvent;
import com.github.gwtbootstrap.client.ui.event.ShownHandler;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;

public class Collapse
extends MarkupWidget
implements HasVisibility,
HasVisibleHandlers {
    private String parent;
    private boolean toggle = false;
    private boolean existTrigger = false;
    private boolean dafaultOpen;

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
    }

    public void setDefaultOpen(boolean dafaultOpen) {
        this.dafaultOpen = dafaultOpen;
        if (this.widget != null && !this.widget.isAttached()) {
            this.widget.setStyleName("in", dafaultOpen);
        }
    }

    @Override
    public Widget asWidget() {
        if (this.widget != null) {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    if (!Collapse.this.isExistTrigger()) {
                        Collapse.this.reconfigure();
                    } else {
                        Collapse.this.configure(Collapse.this.widget.getElement(), Collapse.this.parent, Collapse.this.toggle);
                        Collapse.this.setHandlerFunctions(Collapse.this.widget.getElement());
                    }
                }
            });
        }
        return this.getWidget();
    }

    @Override
    public void setWidget(Widget w) {
        super.setWidget(w);
        if (this.widget != null) {
            this.widget.addStyleName("collapse");
        }
    }

    @Override
    public HandlerRegistration addHideHandler(HideHandler handler) {
        return this.getWidget().addHandler((EventHandler)handler, HideEvent.getType());
    }

    @Override
    public HandlerRegistration addHiddenHandler(HiddenHandler handler) {
        return this.getWidget().addHandler((EventHandler)handler, HiddenEvent.getType());
    }

    @Override
    public HandlerRegistration addShowHandler(ShowHandler handler) {
        return this.getWidget().addHandler((EventHandler)handler, ShowEvent.getType());
    }

    @Override
    public HandlerRegistration addShownHandler(ShownHandler handler) {
        return this.getWidget().addHandler((EventHandler)handler, ShownEvent.getType());
    }

    public void show(boolean autoShown) {
        this.changeVisibility(VisibilityChange.SHOW, autoShown);
    }

    @Override
    public void show() {
        this.changeVisibility(VisibilityChange.SHOW);
    }

    @Override
    public void hide() {
        this.changeVisibility(VisibilityChange.HIDE);
    }

    public void hide(boolean autoHidden) {
        this.changeVisibility(VisibilityChange.HIDE, autoHidden);
    }

    @Override
    public void toggle() {
        this.changeVisibility(VisibilityChange.TOGGLE);
    }

    protected void changeVisibility(VisibilityChange visibilityChange) {
        if (this.widget == null) {
            return;
        }
        this.changeVisibility(this.widget.getElement(), visibilityChange.get());
    }

    protected void changeVisibility(VisibilityChange visibilityChange, boolean autoTriggered) {
        if (this.widget == null) {
            return;
        }
        this.changeVisibility(this.widget.getElement(), visibilityChange.get(), autoTriggered);
    }

    public boolean isExistTrigger() {
        return this.existTrigger;
    }

    public void setExistTrigger(boolean existTrigger) {
        this.existTrigger = existTrigger;
    }

    public void reconfigure() {
        if (this.widget == null) {
            return;
        }
        this.setDefaultOpen(this.dafaultOpen);
        this.removeDataIfExists(this.widget.getElement());
        this.setHandlerFunctions(this.widget.getElement());
        this.configure(this.widget.getElement(), this.parent, this.toggle);
    }

    public native void configure(Element var1, String var2, boolean var3);

    public static native void configure(String var0, String var1, boolean var2);

    protected native void removeDataIfExists(Element var1);

    protected native void setHandlerFunctions(Element var1);

    protected native void changeVisibility(Element var1, String var2);

    protected native void changeVisibility(Element var1, String var2, boolean var3);

    public static native void changeVisibility(String var0, String var1);

    public static native void changeVisibility(String var0, String var1, boolean var2);

    private native boolean getAutoTriggered(JavaScriptObject var1);

    protected void onHide(Event e) {
        this.widget.fireEvent((GwtEvent)new HideEvent((NativeEvent)e, this.getAutoTriggered((JavaScriptObject)e)));
    }

    protected void onHidden(Event e) {
        this.widget.fireEvent((GwtEvent)new HiddenEvent((NativeEvent)e, this.getAutoTriggered((JavaScriptObject)e)));
    }

    protected void onShow(Event e) {
        this.widget.fireEvent((GwtEvent)new ShowEvent((NativeEvent)e, this.getAutoTriggered((JavaScriptObject)e)));
    }

    protected void onShown(Event e) {
        this.widget.fireEvent((GwtEvent)new ShownEvent((NativeEvent)e, this.getAutoTriggered((JavaScriptObject)e)));
    }
}

