/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.resources.prettify.HasProgrammingLanguage;
import com.github.gwtbootstrap.client.ui.resources.prettify.PrettifyHelper;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.Widget;

public class CodeBlock
extends HTMLPanel
implements HasProgrammingLanguage,
HasHTML {
    private final PrettifyHelper helper = new PrettifyHelper((Widget)this);
    private boolean linenums = false;

    public CodeBlock() {
        super("pre", "");
    }

    public CodeBlock(String content) {
        this();
        this.setHTML(content);
    }

    public void setScrollable(boolean scrollable) {
        if (scrollable) {
            this.addStyleName("pre-scrollable");
        } else {
            this.removeStyleName("pre-scrollable");
        }
    }

    public void setLinenums(boolean linenums) {
        this.linenums = linenums;
    }

    public String getHTML() {
        return this.getElement().getInnerHTML();
    }

    public void setHTML(String html) {
        String[] lines = html.split("\\\\n");
        SafeHtmlBuilder shb = new SafeHtmlBuilder();
        for (String s : lines) {
            shb.appendEscaped(s);
            shb.appendHtmlConstant("<br/>");
        }
        if (this.getStyleName().contains("prettyprinted")) {
            this.removeStyleName("prettyprinted");
        }
        this.getElement().setInnerHTML(shb.toSafeHtml().asString());
        if (this.isAttached()) {
            this.helper.configure(this.linenums);
        }
    }

    public String getText() {
        return this.getHTML();
    }

    public void setText(String text) {
        this.setHTML(text);
    }

    @Override
    public void setLang(String programmingLanguage) {
        this.helper.setLang(programmingLanguage);
    }

    protected void onLoad() {
        super.onLoad();
        this.helper.configure(this.linenums);
    }
}

