/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.HasId;
import com.github.gwtbootstrap.client.ui.base.HasStyle;
import com.github.gwtbootstrap.client.ui.base.IsResponsive;
import com.github.gwtbootstrap.client.ui.base.IsSearchQuery;
import com.github.gwtbootstrap.client.ui.base.ResponsiveHelper;
import com.github.gwtbootstrap.client.ui.base.SearchQueryStyleHelper;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.Device;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.ButtonBase;
import com.google.gwt.user.client.ui.DirectionalTextHelper;
import com.google.gwt.user.client.ui.HasDirectionalSafeHtml;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HasWordWrap;

public class CheckBox
extends ButtonBase
implements HasName,
HasValue<Boolean>,
HasWordWrap,
HasDirectionalSafeHtml,
HasDirectionEstimator,
IsEditor<LeafValueEditor<Boolean>>,
IsSearchQuery,
HasId,
IsResponsive,
HasStyle {
    public static final DirectionEstimator DEFAULT_DIRECTION_ESTIMATOR = DirectionalTextHelper.DEFAULT_DIRECTION_ESTIMATOR;
    final DirectionalTextHelper directionalTextHelper;
    InputElement inputElem;
    SpanElement spanElem;
    private LeafValueEditor<Boolean> editor;
    private boolean valueChangeHandlerInitialized;

    public CheckBox() {
        this(DOM.createInputCheck());
    }

    public CheckBox(SafeHtml label) {
        this(label.asString(), true);
    }

    public CheckBox(SafeHtml label, HasDirection.Direction dir) {
        this();
        this.setHTML(label, dir);
    }

    public CheckBox(SafeHtml label, DirectionEstimator directionEstimator) {
        this();
        this.setDirectionEstimator(directionEstimator);
        this.setHTML(label.asString());
    }

    public CheckBox(String label) {
        this();
        this.setText(label);
    }

    public CheckBox(String label, HasDirection.Direction dir) {
        this();
        this.setText(label, dir);
    }

    public CheckBox(String label, DirectionEstimator directionEstimator) {
        this();
        this.setDirectionEstimator(directionEstimator);
        this.setText(label);
    }

    public CheckBox(String label, boolean asHTML) {
        this();
        if (asHTML) {
            this.setHTML(label);
        } else {
            this.setText(label);
        }
    }

    protected CheckBox(Element elem) {
        super(DOM.createLabel());
        assert (elem.hasAttribute("type")) : "The elem should has type attributes";
        String elementType = elem.getAttribute("type");
        if ("checkbox".equalsIgnoreCase(elementType)) {
            this.setStyleName("checkbox");
        } else if ("radio".equalsIgnoreCase(elementType)) {
            this.setStyleName("radio");
        }
        this.inputElem = InputElement.as((Element)elem);
        this.spanElem = Document.get().createSpanElement();
        this.getElement().appendChild((Node)this.inputElem);
        this.getElement().appendChild((Node)this.spanElem);
        String uid = DOM.createUniqueId();
        this.inputElem.setPropertyString("id", uid);
        this.asLabel().setHtmlFor(uid);
        this.directionalTextHelper = new DirectionalTextHelper((Element)this.spanElem, false);
        this.setTabIndex(0);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
        if (!this.valueChangeHandlerInitialized) {
            this.ensureDomEventHandlers();
            this.valueChangeHandlerInitialized = true;
        }
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public LeafValueEditor<Boolean> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of((TakesValue)this);
        }
        return this.editor;
    }

    public DirectionEstimator getDirectionEstimator() {
        return this.directionalTextHelper.getDirectionEstimator();
    }

    public String getFormValue() {
        return this.inputElem.getValue();
    }

    public String getHTML() {
        return this.directionalTextHelper.getTextOrHtml(true);
    }

    public String getName() {
        return this.inputElem.getName();
    }

    public int getTabIndex() {
        return this.inputElem.getTabIndex();
    }

    public String getText() {
        return this.directionalTextHelper.getTextOrHtml(false);
    }

    public HasDirection.Direction getTextDirection() {
        return this.directionalTextHelper.getTextDirection();
    }

    public Boolean getValue() {
        if (this.isAttached()) {
            return this.inputElem.isChecked();
        }
        return this.inputElem.isDefaultChecked();
    }

    public boolean getWordWrap() {
        return !this.getElement().getStyle().getProperty("whiteSpace").equals("nowrap");
    }

    @Deprecated
    public boolean isChecked() {
        return this.getValue() == true;
    }

    public boolean isEnabled() {
        return !this.inputElem.isDisabled();
    }

    public void setAccessKey(char key) {
        this.inputElem.setAccessKey("" + key);
    }

    @Deprecated
    public void setChecked(boolean checked) {
        this.setValue(checked);
    }

    public void setDirectionEstimator(boolean enabled) {
        this.directionalTextHelper.setDirectionEstimator(enabled);
    }

    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.directionalTextHelper.setDirectionEstimator(directionEstimator);
    }

    public void setEnabled(boolean enabled) {
        this.inputElem.setDisabled(!enabled);
        if (enabled) {
            this.inputElem.removeClassName("disabled");
        } else {
            this.inputElem.addClassName("disabled");
        }
    }

    public void setFocus(boolean focused) {
        if (focused) {
            this.inputElem.focus();
        } else {
            this.inputElem.blur();
        }
    }

    public void setFormValue(String value) {
        this.inputElem.setAttribute("value", value);
    }

    public void setHTML(SafeHtml html, HasDirection.Direction dir) {
        this.directionalTextHelper.setTextOrHtml(html.asString(), dir, true);
    }

    public void setHTML(String html) {
        this.directionalTextHelper.setTextOrHtml(html, true);
    }

    public void setName(String name) {
        this.inputElem.setName(name);
    }

    public void setTabIndex(int index) {
        if (this.inputElem != null) {
            this.inputElem.setTabIndex(index);
        }
    }

    public void setText(String text) {
        this.directionalTextHelper.setTextOrHtml(text, false);
    }

    public void setText(String text, HasDirection.Direction dir) {
        this.directionalTextHelper.setTextOrHtml(text, dir, false);
    }

    public void setValue(Boolean value) {
        this.setValue(value, false);
    }

    public void setValue(Boolean value, boolean fireEvents) {
        if (value == null) {
            value = Boolean.FALSE;
        }
        Boolean oldValue = this.getValue();
        this.inputElem.setChecked(value.booleanValue());
        this.inputElem.setDefaultChecked(value.booleanValue());
        if (value.equals(oldValue)) {
            return;
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public void setWordWrap(boolean wrap) {
        this.getElement().getStyle().setProperty("whiteSpace", wrap ? "normal" : "nowrap");
    }

    public void sinkEvents(int eventBitsToAdd) {
        if (this.isOrWasAttached()) {
            Event.sinkEvents((Element)this.inputElem, (int)(eventBitsToAdd | Event.getEventsSunk((Element)this.inputElem)));
        } else {
            super.sinkEvents(eventBitsToAdd);
        }
    }

    protected void ensureDomEventHandlers() {
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValueChangeEvent.fire((HasValueChangeHandlers)CheckBox.this, (Object)CheckBox.this.getValue());
            }
        });
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        CheckBox.ensureDebugId((Element)this.asLabel(), (String)baseID, (String)"label");
        CheckBox.ensureDebugId((Element)this.inputElem, (String)baseID, (String)"input");
        this.asLabel().setHtmlFor(this.inputElem.getId());
    }

    protected void onLoad() {
        this.setEventListener((Element)this.inputElem, (EventListener)this);
    }

    protected void onUnload() {
        this.setEventListener(this.asOld((Element)this.inputElem), null);
        this.setValue(this.getValue());
    }

    protected void replaceInputElement(Element elem) {
        InputElement newInputElem = InputElement.as((Element)elem);
        int tabIndex = this.getTabIndex();
        boolean checked = this.getValue();
        boolean enabled = this.isEnabled();
        String formValue = this.getFormValue();
        String uid = this.inputElem.getId();
        String accessKey = this.inputElem.getAccessKey();
        int sunkEvents = Event.getEventsSunk((Element)this.inputElem);
        this.setEventListener(this.asOld((Element)this.inputElem), null);
        this.getElement().replaceChild((Node)newInputElem, (Node)this.inputElem);
        Event.sinkEvents((Element)elem, (int)Event.getEventsSunk((Element)this.inputElem));
        Event.sinkEvents((Element)this.inputElem, (int)0);
        this.inputElem = newInputElem;
        Event.sinkEvents((Element)this.inputElem, (int)sunkEvents);
        this.inputElem.setId(uid);
        if (!"".equals(accessKey)) {
            this.inputElem.setAccessKey(accessKey);
        }
        this.setTabIndex(tabIndex);
        this.setValue(checked);
        this.setEnabled(enabled);
        this.setFormValue(formValue);
        if (this.isAttached()) {
            this.setEventListener(this.asOld((Element)this.inputElem), (EventListener)this);
        }
    }

    private Element asOld(Element elem) {
        Element oldSchool = (Element)elem.cast();
        return oldSchool;
    }

    private void setEventListener(Element e, EventListener listener) {
        DOM.setEventListener((Element)this.asOld(e), (EventListener)listener);
    }

    protected LabelElement asLabel() {
        return LabelElement.as((Element)this.getElement());
    }

    public void setInline(boolean inline) {
        if (this.getStyleName().contains("inline")) {
            this.removeStyleName("inline");
        }
        if (inline) {
            this.addStyleName("inline");
        }
    }

    @Override
    public void setSearchQuery(boolean searchQuery) {
        SearchQueryStyleHelper.setSearchQuery((Element)this.inputElem, searchQuery);
    }

    @Override
    public boolean isSearchQuery() {
        return SearchQueryStyleHelper.isSearchQuery((Element)this.inputElem);
    }

    @Override
    public String getId() {
        return this.inputElem.getId();
    }

    @Override
    public void setId(String id) {
        this.inputElem.setId(id);
        this.asLabel().setHtmlFor(id);
    }

    @Override
    public void setShowOn(Device device) {
        ResponsiveHelper.setShowOn(this, device);
    }

    @Override
    public void setHideOn(Device device) {
        ResponsiveHelper.setHideOn(this, device);
    }

    @Override
    public void setStyle(Style style) {
        StyleHelper.setStyle(this, style);
    }

    @Override
    public void addStyle(Style style) {
        StyleHelper.addStyle(this, style);
    }

    @Override
    public void removeStyle(Style style) {
        StyleHelper.removeStyle(this, style);
    }
}

