/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.NavWidget;
import com.github.gwtbootstrap.client.ui.base.ComplexWidget;
import com.github.gwtbootstrap.client.ui.base.ListItem;
import com.github.gwtbootstrap.client.ui.base.UnorderedList;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Breadcrumbs
extends UnorderedList {
    private WidgetCollection children = new WidgetCollection((HasWidgets)this);
    private List<Divider> dividerList = new ArrayList<Divider>();
    private String divider = "/";

    public Breadcrumbs() {
        this.setStyleName("breadcrumb");
    }

    public Breadcrumbs(Widget ... widgets) {
        this();
        for (Widget widget : widgets) {
            this.add(widget);
        }
    }

    public Breadcrumbs(String divider) {
        this();
        this.setDivider(divider);
    }

    public void setDivider(String divider) {
        this.divider = divider == null || divider.isEmpty() ? "/" : divider;
        for (Divider dividerWidget : this.dividerList) {
            dividerWidget.setDivider(this.divider);
        }
    }

    protected void onAttach() {
        if (!this.isOrWasAttached() && this.children.size() > 0) {
            Widget lastWidget = this.children.get(this.children.size() - 1);
            for (Widget w : this.children) {
                ListItem item = lastWidget.equals(w) ? this.change2TextListItem(w) : this.getOrCreateListItem(w);
                super.add((Widget)item);
            }
        }
        super.onAttach();
    }

    @Override
    public void add(Widget w) {
        w.removeStyleName("active");
        if (!this.isOrWasAttached()) {
            this.children.add(w);
            return;
        }
        if (this.children.size() > 0) {
            super.remove(this.getWidget(this.getWidgetCount() - 1));
            ListItem item = this.getOrCreateListItem(this.children.get(this.children.size() - 1));
            super.add((Widget)item);
        }
        ListItem newest = this.change2TextListItem(w);
        super.add((Widget)newest);
        this.children.add(w);
    }

    private ListItem getOrCreateListItem(Widget lastWidget) {
        ListItem item = null;
        Divider dividerWidget = new Divider(this.divider);
        if (lastWidget instanceof NavWidget) {
            NavWidget w = (NavWidget)lastWidget;
            if (this.hasDivier(w)) {
                return w;
            }
            this.dividerList.add(dividerWidget);
            w.addWidget((Widget)dividerWidget);
            return w;
        }
        item = lastWidget instanceof ListItem ? (ListItem)lastWidget : new ListItem(lastWidget);
        if (this.hasDivier(item)) {
            return item;
        }
        item.add((Widget)dividerWidget);
        this.dividerList.add(dividerWidget);
        return item;
    }

    private boolean hasDivier(ListItem item) {
        Iterator i$ = item.iterator();
        while (i$.hasNext()) {
            Widget w = (Widget)i$.next();
            if (!(w instanceof Divider)) continue;
            return true;
        }
        return false;
    }

    private ListItem change2TextListItem(Widget w) {
        String text = null;
        text = w instanceof HasText ? ((HasText)w).getText() : w.getElement().getInnerText();
        ListItem newest = new ListItem();
        newest.setStyleName("active");
        newest.getElement().appendChild((Node)Document.get().createTextNode(text));
        return newest;
    }

    public boolean remove(Widget w) {
        boolean isLastWidget;
        if (!this.isOrWasAttached() && this.children.contains(w)) {
            this.children.remove(w);
            return true;
        }
        if (this.getWidgetIndex(w) < 0 && !this.children.contains(w)) {
            return false;
        }
        boolean bl = isLastWidget = this.children.indexOf(w) == this.children.size() - 1 || this.getWidgetIndex(w) == this.getWidgetCount() - 1;
        if (this.getWidgetIndex(w) >= 0 && this.children.contains(w)) {
            this.children.remove(w);
            super.remove(w);
        } else if (this.getWidgetIndex(w) >= 0 && !this.children.contains(w)) {
            this.children.remove(this.getWidgetIndex(w));
            super.remove(w);
        } else {
            if (this.getWidgetIndex(w) < 0 && this.children.contains(w)) {
                return this.remove(this.getWidget(this.children.indexOf(w)));
            }
            return false;
        }
        if (isLastWidget && this.getWidgetCount() > 0) {
            Widget l = this.getWidget(this.getWidgetCount() - 1);
            super.remove(l);
            super.add((Widget)this.change2TextListItem(l));
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.children = new WidgetCollection((HasWidgets)this);
        this.dividerList.clear();
    }

    private static class Divider
    extends ComplexWidget {
        public Divider(String divider) {
            super("span");
            this.setStyleName("divider");
            this.setDivider(divider);
        }

        public void setDivider(String divider) {
            this.getElement().setInnerText(divider);
        }
    }
}

