/*
 *  Copyright 2012 GWT-Bootstrap
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package com.github.gwtbootstrap.client.ui.constants;

//@formatter:off

/**
 * Type of the <a href="http://glyphicons.com/">Glyphicon</a>
 * and <a href="http://fortawesome.github.com/Font-Awesome/">Font Awesome</a>.
 *
 * @author Carlos Alexandro Becker
 * @author Dominik Mayer
 * @see <a href="http://twitter.github.com/bootstrap/base-css.html#icons">Bootstrap documentation</a>
 * @see <a href="http://fortawesome.github.com/Font-Awesome/">Font Awesome docs</a>
 * @since 2.0.4.0
 */
//@formatter:on
public enum IconType implements BaseIconType {

    // font awesome icons
    ADJUST("adjust"),
    ADN("adn"),
    ALIGN_CENTER("align-center"),
    ALIGN_JUSTIFY("align-justify"),
    ALIGN_LEFT("align-left"),
    ALIGN_RIGHT("align-right"),
    AMBULANCE("ambulance"),
    ANCHOR("anchor"),
    ANDROID("android"),
    ANGLE_DOWN("angle-down"),
    ANGLE_LEFT("angle-left"),
    ANGLE_RIGHT("angle-right"),
    ANGLE_UP("angle-up"),
    APPLE("apple"),
    ARCHIVE("archive"),
    ARROW_DOWN("arrow-down"),
    ARROW_LEFT("arrow-left"),
    ARROW_RIGHT("arrow-right"),
    ARROW_UP("arrow-up"),
    ASTERISK("asterisk"),
    BACKWARD("backward"),
    BAN_CIRCLE("ban-circle"),
    BARCODE("barcode"),
    BAR_CHART("bar-chart"),
    BEAKER("beaker"),
    BEER("beer"),
    BELL("bell"),
    BELL_ALT("bell-alt"),
    BITBUCKET("bitbucket"),
    BITBUCKET_SIGN("bitbucket-sign"),
    BITCOIN("bitcoin"),
    BOLD("bold"),
    BOLT("bolt"),
    BOOK("book"),
    BOOKMARK("bookmark"),
    BOOKMARK_EMPTY("bookmark-empty"),
    BRIEFCASE("briefcase"),
    BTC("btc"),
    BUG("bug"),
    BUILDING("building"),
    BULLHORN("bullhorn"),
    BULLSEYE("bullseye"),
    CALENDAR("calendar"),
    CALENDAR_EMPTY("calendar-empty"),
    CAMERA("camera"),
    CAMERA_RETRO("camera-retro"),
    CARET_DOWN("caret-down"),
    CARET_LEFT("caret-left"),
    CARET_RIGHT("caret-right"),
    CARET_UP("caret-up"),
    CERTIFICATE("certificate"),
    CHECK("check"),
    CHECK_EMPTY("check-empty"),
    CHECK_MINUS("check-minus"),
    CHECK_SIGN("check-sign"),
    CHEVRON_DOWN("chevron-down"),
    CHEVRON_LEFT("chevron-left"),
    CHEVRON_RIGHT("chevron-right"),
    CHEVRON_SIGN_DOWN("chevron-sign-down"),
    CHEVRON_SIGN_LEFT("chevron-sign-left"),
    CHEVRON_SIGN_RIGHT("chevron-sign-right"),
    CHEVRON_SIGN_UP("chevron-sign-up"),
    CHEVRON_UP("chevron-up"),
    CIRCLE("circle"),
    CIRCLE_ARROW_DOWN("circle-arrow-down"),
    CIRCLE_ARROW_LEFT("circle-arrow-left"),
    CIRCLE_ARROW_RIGHT("circle-arrow-right"),
    CIRCLE_ARROW_UP("circle-arrow-up"),
    CIRCLE_BLANK("circle-blank"),
    CLOUD("cloud"),
    CLOUD_DOWNLOAD("cloud-download"),
    CLOUD_UPLOAD("cloud-upload"),
    CNY("cny"),
    CODE("code"),
    CODE_FORK("code-fork"),
    COFFEE("coffee"),
    COG("cog"),
    COGS("cogs"),
    COLLAPSE("collapse"),
    COLLAPSE_ALT("collapse-alt"),
    COLLAPSE_TOP("collapse-top"),
    COLUMNS("columns"),
    COMMENT("comment"),
    COMMENTS("comments"),
    COMMENTS_ALT("comments-alt"),
    COMMENT_ALT("comment-alt"),
    COMPASS("compass"),
    COPY("copy"),
    CREDIT_CARD("credit-card"),
    CROP("crop"),
    CSS3("css3"),
    CUT("cut"),
    DASHBOARD("dashboard"),
    DESKTOP("desktop"),
    DOLLAR("dollar"),
    DOUBLE_ANGLE_DOWN("double-angle-down"),
    DOUBLE_ANGLE_LEFT("double-angle-left"),
    DOUBLE_ANGLE_RIGHT("double-angle-right"),
    DOUBLE_ANGLE_UP("double-angle-up"),
    DOWNLOAD("download"),
    DOWNLOAD_ALT("download-alt"),
    DRIBBBLE("dribbble"),
    DROPBOX("dropbox"),
    EDIT("edit"),
    EDIT_SIGN("edit-sign"),
    EJECT("eject"),
    ELLIPSIS_HORIZONTAL("ellipsis-horizontal"),
    ELLIPSIS_VERTICAL("ellipsis-vertical"),
    ENVELOPE("envelope"),
    ENVELOPE_ALT("envelope-alt"),
    ERASER("eraser"),
    EUR("eur"),
    EURO("euro"),
    EXCHANGE("exchange"),
    EXCLAMATION("exclamation"),
    EXCLAMATION_SIGN("exclamation-sign"),
    EXPAND("expand"),
    EXPAND_ALT("expand-alt"),
    EXTERNAL_LINK("external-link"),
    EXTERNAL_LINK_SIGN("external-link-sign"),
    EYE_CLOSE("eye-close"),
    EYE_OPEN("eye-open"),
    FACEBOOK("facebook"),
    FACEBOOK_SIGN("facebook-sign"),
    FACETIME_VIDEO("facetime-video"),
    FAST_BACKWARD("fast-backward"),
    FAST_FORWARD("fast-forward"),
    FEMALE("female"),
    FIGHTER_JET("fighter-jet"),
    FILE("file"),
    FILE_ALT("file-alt"),
    FILE_TEXT("file-text"),
    FILE_TEXT_ALT("file-text-alt"),
    FILM("film"),
    FILTER("filter"),
    FIRE("fire"),
    FIRE_EXTINGUISHER("fire-extinguisher"),
    FLAG("flag"),
    FLAG_ALT("flag-alt"),
    FLAG_CHECKERED("flag-checkered"),
    FLICKR("flickr"),
    FLIP_HORIZONTAL("flip-horizontal"),
    FLIP_VERTICAL("flip-vertical"),
    FOLDER_CLOSE("folder-close"),
    FOLDER_CLOSE_ALT("folder-close-alt"),
    FOLDER_OPEN("folder-open"),
    FOLDER_OPEN_ALT("folder-open-alt"),
    FONT("font"),
    FOOD("food"),
    FORWARD("forward"),
    FOURSQUARE("foursquare"),
    FROWN("frown"),
    FULLSCREEN("fullscreen"),
    GAMEPAD("gamepad"),
    GBP("gbp"),
    GEAR("gear"),
    GEARS("gears"),
    GIFT("gift"),
    GITHUB("github"),
    GITHUB_ALT("github-alt"),
    GITHUB_SIGN("github-sign"),
    GITTIP("gittip"),
    GLASS("glass"),
    GLOBE("globe"),
    GOOGLE_PLUS("google-plus"),
    GOOGLE_PLUS_SIGN("google-plus-sign"),
    GROUP("group"),
    HAND_DOWN("hand-down"),
    HAND_LEFT("hand-left"),
    HAND_RIGHT("hand-right"),
    HAND_UP("hand-up"),
    HDD("hdd"),
    HEADPHONES("headphones"),
    HEART("heart"),
    HEART_EMPTY("heart-empty"),
    HOME("home"),
    HOSPITAL("hospital"),
    HTML5("html5"),
    H_SIGN("h-sign"),
    INBOX("inbox"),
    INDENT_LEFT("indent-left"),
    INDENT_RIGHT("indent-right"),
    INFO("info"),
    INFO_SIGN("info-sign"),
    INR("inr"),
    INSTAGRAM("instagram"),
    ITALIC("italic"),
    JPY("jpy"),
    KEY("key"),
    KEYBOARD("keyboard"),
    KRW("krw"),
    LAPTOP("laptop"),
    LARGE("large"),
    LEAF("leaf"),
    LEGAL("legal"),
    LEMON("lemon"),
    LEVEL_DOWN("level-down"),
    LEVEL_UP("level-up"),
    LIGHTBULB("lightbulb"),
    LINK("link"),
    LINKEDIN("linkedin"),
    LINKEDIN_SIGN("linkedin-sign"),
    LINUX("linux"),
    LIST("list"),
    LIST_ALT("list-alt"),
    LIST_OL("list-ol"),
    LIST_UL("list-ul"),
    LOCATION_ARROW("location-arrow"),
    LOCK("lock"),
    LONG_ARROW_DOWN("long-arrow-down"),
    LONG_ARROW_LEFT("long-arrow-left"),
    LONG_ARROW_RIGHT("long-arrow-right"),
    LONG_ARROW_UP("long-arrow-up"),
    MAGIC("magic"),
    MAGNET("magnet"),
    MAIL_FORWARD("mail-forward"),
    MAIL_REPLY("mail-reply"),
    MAIL_REPLY_ALL("mail-reply-all"),
    MALE("male"),
    MAP_MARKER("map-marker"),
    MAXCDN("maxcdn"),
    MEDKIT("medkit"),
    MEH("meh"),
    MICROPHONE("microphone"),
    MICROPHONE_OFF("microphone-off"),
    MINUS("minus"),
    MINUS_SIGN("minus-sign"),
    MINUS_SIGN_ALT("minus-sign-alt"),
    MOBILE_PHONE("mobile-phone"),
    MONEY("money"),
    MOON("moon"),
    MOVE("move"),
    MUSIC("music"),
    OFF("off"),
    OK("ok"),
    OK_CIRCLE("ok-circle"),
    OK_SIGN("ok-sign"),
    PAPERCLIP("paperclip"),
    PAPER_CLIP("paper-clip"),
    PASTE("paste"),
    PAUSE("pause"),
    PENCIL("pencil"),
    PHONE("phone"),
    PHONE_SIGN("phone-sign"),
    PICTURE("picture"),
    PINTEREST("pinterest"),
    PINTEREST_SIGN("pinterest-sign"),
    PLANE("plane"),
    PLAY("play"),
    PLAY_CIRCLE("play-circle"),
    PLAY_SIGN("play-sign"),
    PLUS("plus"),
    PLUS_SIGN("plus-sign"),
    PLUS_SIGN_ALT("plus-sign-alt"),
    POWER_OFF("power-off"),
    PRINT("print"),
    PUSHPIN("pushpin"),
    PUZZLE_PIECE("puzzle-piece"),
    QRCODE("qrcode"),
    QUESTION("question"),
    QUESTION_SIGN("question-sign"),
    QUOTE_LEFT("quote-left"),
    QUOTE_RIGHT("quote-right"),
    RANDOM("random"),
    REFRESH("refresh"),
    REMOVE("remove"),
    REMOVE_CIRCLE("remove-circle"),
    REMOVE_SIGN("remove-sign"),
    RENMINBI("renminbi"),
    RENREN("renren"),
    REORDER("reorder"),
    REPEAT("repeat"),
    REPLY("reply"),
    REPLY_ALL("reply-all"),
    RESIZE_FULL("resize-full"),
    RESIZE_HORIZONTAL("resize-horizontal"),
    RESIZE_SMALL("resize-small"),
    RESIZE_VERTICAL("resize-vertical"),
    RETWEET("retweet"),
    ROAD("road"),
    ROCKET("rocket"),
    ROTATE_180("rotate-180"),
    ROTATE_270("rotate-270"),
    ROTATE_90("rotate-90"),
    ROTATE_LEFT("rotate-left"),
    ROTATE_RIGHT("rotate-right"),
    RSS("rss"),
    RSS_SIGN("rss-sign"),
    RUPEE("rupee"),
    SAVE("save"),
    SCREENSHOT("screenshot"),
    SEARCH("search"),
    SHARE("share"),
    SHARE_ALT("share-alt"),
    SHARE_SIGN("share-sign"),
    SHIELD("shield"),
    SHOPPING_CART("shopping-cart"),
    SIGNAL("signal"),
    SIGNIN("signin"),
    SIGNOUT("signout"),
    SIGN_BLANK("sign-blank"),
    SITEMAP("sitemap"),
    SKYPE("skype"),
    SMILE("smile"),
    SORT("sort"),
    SORT_BY_ALPHABET("sort-by-alphabet"),
    SORT_BY_ALPHABET_ALT("sort-by-alphabet-alt"),
    SORT_BY_ATTRIBUTES("sort-by-attributes"),
    SORT_BY_ATTRIBUTES_ALT("sort-by-attributes-alt"),
    SORT_BY_ORDER("sort-by-order"),
    SORT_BY_ORDER_ALT("sort-by-order-alt"),
    SORT_DOWN("sort-down"),
    SORT_UP("sort-up"),
    SPINNER("spinner"),
    STACKEXCHANGE("stackexchange"),
    STAR("star"),
    STAR_EMPTY("star-empty"),
    STAR_HALF("star-half"),
    STAR_HALF_EMPTY("star-half-empty"),
    STAR_HALF_FULL("star-half-full"),
    STEP_BACKWARD("step-backward"),
    STEP_FORWARD("step-forward"),
    STETHOSCOPE("stethoscope"),
    STOP("stop"),
    STRIKETHROUGH("strikethrough"),
    SUBSCRIPT("subscript"),
    SUITCASE("suitcase"),
    SUN("sun"),
    SUPERSCRIPT("superscript"),
    TABLE("table"),
    TABLET("tablet"),
    TAG("tag"),
    TAGS("tags"),
    TASKS("tasks"),
    TERMINAL("terminal"),
    TEXT_HEIGHT("text-height"),
    TEXT_WIDTH("text-width"),
    TH("th"),
    THUMBS_DOWN("thumbs-down"),
    THUMBS_DOWN_ALT("thumbs-down-alt"),
    THUMBS_UP("thumbs-up"),
    THUMBS_UP_ALT("thumbs-up-alt"),
    TH_LARGE("th-large"),
    TH_LIST("th-list"),
    TICKET("ticket"),
    TIME("time"),
    TINT("tint"),
    TRASH("trash"),
    TRELLO("trello"),
    TROPHY("trophy"),
    TRUCK("truck"),
    TUMBLR("tumblr"),
    TUMBLR_SIGN("tumblr-sign"),
    TWITTER("twitter"),
    TWITTER_SIGN("twitter-sign"),
    UMBRELLA("umbrella"),
    UNCHECKED("unchecked"),
    UNDERLINE("underline"),
    UNDO("undo"),
    UNLINK("unlink"),
    UNLOCK("unlock"),
    UNLOCK_ALT("unlock-alt"),
    UPLOAD("upload"),
    UPLOAD_ALT("upload-alt"),
    USD("usd"),
    USER("user"),
    USER_MD("user-md"),
    VK("vk"),
    VOLUME_DOWN("volume-down"),
    VOLUME_OFF("volume-off"),
    VOLUME_UP("volume-up"),
    WARNING_SIGN("warning-sign"),
    WEIBO("weibo"),
    WINDOWS("windows"),
    WON("won"),
    WRENCH("wrench"),
    XING("xing"),
    XING_SIGN("xing-sign"),
    YEN("yen"),
    YOUTUBE("youtube"),
    YOUTUBE_PLAY("youtube-play"),
    YOUTUBE_SIGN("youtube-sign"),
    ZOOM_IN("zoom-in"),
    ZOOM_OUT("zoom-out"),

    // original icons from bootstrap, that not exist in font awesome page, but 'exists'
    BAR("bar");

    private static final String PREFIX = "icon-";

    private String className;

    private IconType(String className) {
        this.className = className;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String get() {
        return PREFIX + className;
    }
}
