package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.constants.Constants;
import com.github.gwtbootstrap.client.ui.constants.LabelType;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;

/**
 * A cell used to render text as a colored label, with a given type (error,
 * warning etc).
 * 
 * @see Label
 */
public class LabelCell extends com.google.gwt.cell.client.TextCell {

	private LabelType type = null;

	/**
	 * Construct a new {@link LabelCell} with the default label type
	 */
	public LabelCell() {
		this(LabelType.DEFAULT);
	}

	/**
	 * Construct a new {@link LabelCell} with the specified label type
	 * 
	 * @param type
	 */
	public LabelCell(LabelType type) {
		this.type = type;
	}

	/**
	 * Set the label type for labels rendered by this cell.
	 * 
	 * @param type
	 */
	public void setType(LabelType type) {
		this.type = type;
	}

	public LabelType getType() {
		return type;
	}

	@Override
	public void render(Context context, SafeHtml value, SafeHtmlBuilder sb) {
		if (value != null) {
			sb.appendHtmlConstant("<span class=\"" + Constants.LABEL + " "
					+ type.get() + "\">");
			sb.append(value);
			sb.appendHtmlConstant("</span>");
		}
	}

}