/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.timepicker.client.ui.base;

import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.base.HasAlternateSize;
import com.github.gwtbootstrap.client.ui.base.HasId;
import com.github.gwtbootstrap.client.ui.base.HasPlaceholder;
import com.github.gwtbootstrap.client.ui.base.HasSize;
import com.github.gwtbootstrap.client.ui.base.HasStyle;
import com.github.gwtbootstrap.client.ui.base.HasVisibility;
import com.github.gwtbootstrap.client.ui.base.IsResponsive;
import com.github.gwtbootstrap.client.ui.base.IsSearchQuery;
import com.github.gwtbootstrap.client.ui.base.PlaceholderHelper;
import com.github.gwtbootstrap.client.ui.base.ResponsiveHelper;
import com.github.gwtbootstrap.client.ui.base.SearchQueryStyleHelper;
import com.github.gwtbootstrap.client.ui.base.SizeHelper;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.AlternateSize;
import com.github.gwtbootstrap.client.ui.constants.Device;
import com.github.gwtbootstrap.client.ui.event.HasVisibleHandlers;
import com.github.gwtbootstrap.client.ui.event.HiddenEvent;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.github.gwtbootstrap.client.ui.event.HideEvent;
import com.github.gwtbootstrap.client.ui.event.HideHandler;
import com.github.gwtbootstrap.client.ui.event.ShowEvent;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.github.gwtbootstrap.client.ui.event.ShownEvent;
import com.github.gwtbootstrap.client.ui.event.ShownHandler;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasDefaultTime;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasDisableFocus;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasMeridian;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasMinuteStep;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasModalBackdrop;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasSecondStep;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasShowInputs;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasShowSeconds;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasTemplate;
import com.github.gwtbootstrap.timepicker.client.ui.base.HasTimeFormat;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;

public class TimeBoxBase
extends Widget
implements HasVisibleHandlers,
HasPlaceholder,
HasTemplate,
HasShowInputs,
HasSecondStep,
HasModalBackdrop,
HasMinuteStep,
HasDisableFocus,
HasDefaultTime,
HasShowSeconds,
HasMeridian,
HasAlternateSize,
IsSearchQuery,
HasSize,
HasId,
IsResponsive,
HasStyle,
HasValue<Date>,
HasEnabled,
HasValueChangeHandlers<Date>,
HasVisibility,
HasTimeFormat {
    private final TextBox box;
    private String format;
    private DateTimeFormat dtf;
    private HasTemplate.Template template = HasTemplate.Template.DROPDOWN;
    private int minuteStep = 15;
    private boolean showSeconds = false;
    private int secondStep = 15;
    private HasDefaultTime.DefaultTime defaultTime = HasDefaultTime.DefaultTime.CURRENT;
    private boolean showMeridian = false;
    private boolean showInputs = true;
    private boolean disableFocus = false;
    private boolean modalBackdrop = false;
    private PlaceholderHelper placeholderHelper = (PlaceholderHelper)GWT.create(PlaceholderHelper.class);

    public TimeBoxBase() {
        this.box = new TextBox();
        this.box.setStyleName("input-mini");
        this.setElement(this.box.getElement());
        this.setFormat("HH:mm:ss a");
        this.setValue(new Date());
    }

    public boolean isReadOnly() {
        return this.box.isReadOnly();
    }

    public void setReadOnly(boolean readonly) {
        this.box.setReadOnly(readonly);
    }

    protected TextBox getBox() {
        return this.box;
    }

    public String getOriginalValue() {
        return this.box.getValue();
    }

    public Date getValue() {
        try {
            return this.dtf != null && this.box.getValue() != null ? this.dtf.parse(this.box.getValue()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setValue(Date value) {
        this.setValue(value, false);
    }

    protected native void updateValue(Element var1);

    public void setValue(Date value, boolean fireEvents) {
        this.box.setValue(value != null ? this.dtf.format(value) : null);
        this.updateValue(this.box.getElement());
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    protected void configure() {
        this.configure(this);
    }

    protected void configure(Widget w) {
        w.getElement().setAttribute("data-date-format", this.format);
        this.configure(w.getElement(), this.template.name().toLowerCase(), this.defaultTime.name().toLowerCase(), this.minuteStep, this.showSeconds, this.secondStep, this.showMeridian, this.showInputs, this.disableFocus, this.modalBackdrop);
    }

    protected native void configure(Element var1, String var2, String var3, int var4, boolean var5, int var6, boolean var7, boolean var8, boolean var9, boolean var10);

    private native void execute(Element var1, String var2);

    private void execute(String cmd) {
        this.execute(this.getElement(), cmd);
    }

    @Override
    public void show() {
        this.execute("show");
    }

    @Override
    public void hide() {
        this.execute("hide");
    }

    @Override
    public void toggle() {
        this.execute("toggle");
    }

    protected native void removeDataIfExists(Element var1);

    public void reconfigure() {
        this.removeDataIfExists(this.getElement());
        this.configure(this.getElement(), this.template.name().toLowerCase(), this.defaultTime.name().toLowerCase(), this.minuteStep, this.showSeconds, this.secondStep, this.showMeridian, this.showInputs, this.disableFocus, this.modalBackdrop);
    }

    protected void onLoad() {
        super.onLoad();
        this.configure(this.getElement(), this.template.name().toLowerCase(), this.defaultTime.name().toLowerCase(), this.minuteStep, this.showSeconds, this.secondStep, this.showMeridian, this.showInputs, this.disableFocus, this.modalBackdrop);
    }

    @Override
    public void setPlaceholder(String placeholder) {
        this.placeholderHelper.setPlaceholer(this.getElement(), placeholder);
    }

    @Override
    public String getPlaceholder() {
        return this.placeholderHelper.getPlaceholder(this.getElement());
    }

    @Override
    public void setTemplate(HasTemplate.Template template) {
        this.template = template;
    }

    @Override
    public void setTemplate(String template) {
        this.template = HasTemplate.Template.valueOf(template);
    }

    @Override
    public void setMeridian(boolean meridian) {
        this.showMeridian = meridian;
    }

    @Override
    public void setAlternateSize(AlternateSize size) {
        StyleHelper.changeStyle((UIObject)this, size, AlternateSize.class);
    }

    @Override
    public String getId() {
        return this.getElement().getId();
    }

    @Override
    public void setId(String id) {
        this.getElement().setId(id);
    }

    @Override
    public void setSize(int size) {
        SizeHelper.setSize((UIObject)this, size);
    }

    @Override
    public void setStyle(Style style) {
        StyleHelper.setStyle(this, style);
    }

    @Override
    public void addStyle(Style style) {
        StyleHelper.addStyle(this, style);
    }

    @Override
    public void removeStyle(Style style) {
        StyleHelper.removeStyle(this, style);
    }

    @Override
    public void setShowOn(Device device) {
        ResponsiveHelper.setHideOn(this, device);
    }

    @Override
    public void setHideOn(Device device) {
        ResponsiveHelper.setHideOn(this, device);
    }

    @Override
    public void setSearchQuery(boolean searchQuery) {
        SearchQueryStyleHelper.setSearchQuery(this, searchQuery);
    }

    @Override
    public boolean isSearchQuery() {
        return SearchQueryStyleHelper.isSearchQuery(this);
    }

    public boolean isEnabled() {
        return this.box.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.box.setEnabled(enabled);
    }

    @Override
    public void setShowSeconds(boolean showSeconds) {
        this.showSeconds = showSeconds;
    }

    @Override
    public void setDisableFocus(boolean disableFocus) {
        this.disableFocus = disableFocus;
    }

    @Override
    public void setModalBackdrop(boolean modalBackdrop) {
        this.modalBackdrop = modalBackdrop;
    }

    @Override
    public void setShowInputs(boolean showInputs) {
        this.showInputs = showInputs;
    }

    @Override
    public void setMinuteStep(int minuteStep) {
        this.minuteStep = minuteStep;
    }

    @Override
    public void setSecondStep(int secondStep) {
        this.secondStep = secondStep;
    }

    @Override
    public void setDefaultTime(HasDefaultTime.DefaultTime defaultTime) {
        this.defaultTime = defaultTime;
    }

    @Override
    public void setDefaultTime(String defaultTime) {
        this.defaultTime = HasDefaultTime.DefaultTime.valueOf(defaultTime);
    }

    @Override
    public HandlerRegistration addHideHandler(HideHandler handler) {
        return this.addHandler(handler, HideEvent.getType());
    }

    @Override
    public HandlerRegistration addHiddenHandler(HiddenHandler handler) {
        return this.addHandler(handler, HiddenEvent.getType());
    }

    @Override
    public HandlerRegistration addShowHandler(ShowHandler handler) {
        return this.addHandler(handler, ShowEvent.getType());
    }

    @Override
    public HandlerRegistration addShownHandler(ShownHandler handler) {
        return this.addHandler(handler, ShownEvent.getType());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
        Date oldValue = this.getValue();
        this.dtf = DateTimeFormat.getFormat((String)format);
        if (oldValue != null) {
            this.setValue(oldValue);
        }
    }
}

