/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.datetimepicker.client.ui.base;

import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.base.HasAlternateSize;
import com.github.gwtbootstrap.client.ui.base.HasId;
import com.github.gwtbootstrap.client.ui.base.HasPlaceholder;
import com.github.gwtbootstrap.client.ui.base.HasSize;
import com.github.gwtbootstrap.client.ui.base.HasStyle;
import com.github.gwtbootstrap.client.ui.base.HasVisibility;
import com.github.gwtbootstrap.client.ui.base.IsResponsive;
import com.github.gwtbootstrap.client.ui.base.IsSearchQuery;
import com.github.gwtbootstrap.client.ui.base.PlaceholderHelper;
import com.github.gwtbootstrap.client.ui.base.ResponsiveHelper;
import com.github.gwtbootstrap.client.ui.base.SearchQueryStyleHelper;
import com.github.gwtbootstrap.client.ui.base.SizeHelper;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.AlternateSize;
import com.github.gwtbootstrap.client.ui.constants.Device;
import com.github.gwtbootstrap.client.ui.event.HasVisibleHandlers;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.github.gwtbootstrap.client.ui.event.HideEvent;
import com.github.gwtbootstrap.client.ui.event.HideHandler;
import com.github.gwtbootstrap.client.ui.event.ShowEvent;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.github.gwtbootstrap.client.ui.event.ShownHandler;
import com.github.gwtbootstrap.datetimepicker.client.ui.base.HasAllDateTimePickerHandlers;
import com.github.gwtbootstrap.datetimepicker.client.ui.base.HasViewMode;
import com.github.gwtbootstrap.datetimepicker.client.ui.base.PickerPosition;
import com.github.gwtbootstrap.datetimepicker.client.ui.util.LocaleUtil;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;

public class DateTimeBoxBase
extends Widget
implements HasValue<Date>,
HasEnabled,
HasValueChangeHandlers<Date>,
HasVisibility,
HasChangeHandlers,
HasVisibleHandlers,
HasAllDateTimePickerHandlers,
IsEditor<TakesValueEditor<Date>>,
HasPlaceholder,
HasAlternateSize,
IsSearchQuery,
HasSize,
HasId,
IsResponsive,
HasStyle {
    private final TextBox box;
    private String format;
    private String language;
    private DateTimeFormat dtf;
    private TakesValueEditor<Date> editor;
    private PlaceholderHelper placeholderHelper = (PlaceholderHelper)GWT.create(PlaceholderHelper.class);
    private boolean autoclose;
    private int minuteStep = 5;
    private boolean todayButton;
    private boolean highlightToday;
    private String minViewMode = HasViewMode.ViewMode.HOUR.name().toLowerCase();
    private String startViewMode = HasViewMode.ViewMode.MONTH.name().toLowerCase();
    private String maxViewMode = HasViewMode.ViewMode.DECADE.name().toLowerCase();
    private PickerPosition pickerPosition = PickerPosition.BOTTOM_RIGHT;
    private Element decoratedElement;

    public DateTimeBoxBase() {
        this.box = new TextBox();
        this.language = LocaleUtil.getLanguage();
        this.setElement(this.box.getElement());
        this.setFormat("yyyy/mm/dd hh:ii");
        this.setWeekStart(LocaleInfo.getCurrentLocale().getDateTimeFormatInfo().firstDayOfTheWeek());
        this.setValue(new Date());
    }

    public void setAlignment(ValueBoxBase.TextAlignment align) {
        this.box.setAlignment(align);
    }

    public boolean isReadOnly() {
        return this.box.isReadOnly();
    }

    public void setReadOnly(boolean readonly) {
        this.box.setReadOnly(readonly);
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
        Date oldValue = this.getValue();
        this.dtf = DateTimeFormat.getFormat((String)this.dpGlobalFormatToDateTimeFormat(format));
        if (oldValue != null) {
            this.setValue(oldValue);
        }
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
        LocaleUtil.forceLocale(language);
    }

    protected TextBox getBox() {
        return this.box;
    }

    public Date getValue() {
        try {
            return this.dtf != null && this.box.getValue() != null ? this.dtf.parse(this.box.getValue()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getOriginalValue() {
        return this.box.getValue();
    }

    public void setValue(Date value) {
        this.setValue(value, false);
    }

    public void setValue(Date value, boolean fireEvents) {
        this.box.setValue(value != null ? this.dtf.format(value) : null);
        this.updateValue(this.decoratedElement);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    protected native void updateValue(Element var1);

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> dateValueChangeHandler) {
        return this.addHandler((EventHandler)dateValueChangeHandler, ValueChangeEvent.getType());
    }

    protected void onLoad() {
        super.onLoad();
        this.configure();
    }

    protected void onUnload() {
        super.onUnload();
        this.execute("remove");
    }

    protected void configure(Widget w) {
        this.decoratedElement = w.getElement();
        w.getElement().setAttribute("data-date-format", this.format);
        w.getElement().setAttribute("data-date-language", this.language);
        this.configure(w.getElement(), this.autoclose, this.minuteStep, this.todayButton, this.highlightToday, this.minViewMode, this.startViewMode, this.maxViewMode, this.pickerPosition.getValue());
    }

    public void onChange() {
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
    }

    public void onShow(Event e) {
        this.fireEvent(new ShowEvent((NativeEvent)e));
    }

    public void onHide(Event e) {
        this.fireEvent(new HideEvent((NativeEvent)e));
    }

    public void reconfigure() {
        this.removeDataIfExists(this.getElement());
        this.configure();
    }

    protected void configure() {
        this.configure(this);
    }

    protected native void removeDataIfExists(Element var1);

    protected native void configure(Element var1, boolean var2, int var3, boolean var4, boolean var5, String var6, String var7, String var8, String var9);

    private native void execute(Element var1, String var2);

    private void execute(String cmd) {
        this.execute(this.getElement(), cmd);
    }

    @Override
    public void show() {
        this.execute("show");
    }

    @Override
    public void hide() {
        this.execute("hide");
    }

    @Override
    public void toggle() {
        throw new UnsupportedOperationException("not support toggle");
    }

    @Override
    public HandlerRegistration addHideHandler(HideHandler handler) {
        return this.addHandler(handler, HideEvent.getType());
    }

    @Override
    public HandlerRegistration addHiddenHandler(HiddenHandler handler) {
        throw new UnsupportedOperationException("not support hidden event");
    }

    @Override
    public HandlerRegistration addShowHandler(ShowHandler handler) {
        return this.addHandler(handler, ShowEvent.getType());
    }

    @Override
    public HandlerRegistration addShownHandler(ShownHandler handler) {
        throw new UnsupportedOperationException("not support shown event");
    }

    @Override
    public void setWeekStart(int start) {
        this.getElement().setAttribute("data-date-weekstart", start + "");
    }

    @Override
    public void setStartDate(String startDate) {
        this.getElement().setAttribute("data-date-startdate", startDate);
    }

    @Override
    public void setStartDate_(Date startDate) {
        this.setStartDate(this.dtf.format(startDate));
    }

    @Override
    public void setEndDate(String endDate) {
        this.getElement().setAttribute("data-date-enddate", endDate);
    }

    @Override
    public void setEndDate_(Date endDate) {
        this.setEndDate(this.dtf.format(endDate));
    }

    @Override
    public void setAutoClose(boolean autoclose) {
        this.autoclose = autoclose;
    }

    @Override
    public void setMinView(HasViewMode.ViewMode mode) {
        this.setMinView(mode.name());
    }

    @Override
    public void setMinView(String mode) {
        this.minViewMode = mode.toLowerCase();
    }

    @Override
    public void setStartView(HasViewMode.ViewMode mode) {
        this.setStartView(mode.name());
    }

    @Override
    public void setStartView(String mode) {
        this.startViewMode = mode.toLowerCase();
    }

    @Override
    public void setMaxView(HasViewMode.ViewMode mode) {
        this.setMaxView(mode.name());
    }

    @Override
    public void setMaxView(String mode) {
        this.maxViewMode = mode.toLowerCase();
    }

    public TakesValueEditor<Date> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of((TakesValue)this);
        }
        return this.editor;
    }

    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addHandler((EventHandler)handler, (GwtEvent.Type)ChangeEvent.getType());
    }

    @Override
    public void setPlaceholder(String placeholder) {
        this.placeholderHelper.setPlaceholer(this.getElement(), placeholder);
    }

    @Override
    public String getPlaceholder() {
        return this.placeholderHelper.getPlaceholder(this.getElement());
    }

    @Override
    public void setSearchQuery(boolean searchQuery) {
        SearchQueryStyleHelper.setSearchQuery(this, searchQuery);
    }

    @Override
    public boolean isSearchQuery() {
        return SearchQueryStyleHelper.isSearchQuery(this);
    }

    @Override
    public void setAlternateSize(AlternateSize size) {
        StyleHelper.changeStyle((UIObject)this, size, AlternateSize.class);
    }

    @Override
    public void setSize(int size) {
        SizeHelper.setSize((UIObject)this, size);
    }

    @Override
    public String getId() {
        return this.getElement().getId();
    }

    @Override
    public void setId(String id) {
        this.getElement().setId(id);
    }

    @Override
    public void setShowOn(Device device) {
        ResponsiveHelper.setShowOn(this, device);
    }

    @Override
    public void setHideOn(Device device) {
        ResponsiveHelper.setHideOn(this, device);
    }

    @Override
    public void setStyle(Style style) {
        StyleHelper.setStyle(this, style);
    }

    @Override
    public void addStyle(Style style) {
        StyleHelper.addStyle(this, style);
    }

    @Override
    public void removeStyle(Style style) {
        StyleHelper.removeStyle(this, style);
    }

    public boolean isEnabled() {
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.box.setEnabled(enabled);
    }

    @Override
    public void setDaysOfWeekDisabled(String value) {
        this.getElement().setAttribute("date-days-of-week-disabled", value);
    }

    @Override
    public void setMinuteStep(int minutes) {
        this.minuteStep = minutes;
    }

    @Override
    public void setShowTodayButton(boolean show) {
        this.todayButton = show;
    }

    @Override
    public void setHighlightToday(boolean highlight) {
        this.highlightToday = highlight;
    }

    public PickerPosition getPickerPosition() {
        return this.pickerPosition;
    }

    public void setPickerPosition(PickerPosition pickerPosition) {
        this.pickerPosition = pickerPosition;
    }

    private String dpGlobalFormatToDateTimeFormat(String dpGlobalFormat) {
        if (dpGlobalFormat == null || dpGlobalFormat.length() == 0) {
            return "";
        }
        char last = dpGlobalFormat.charAt(0);
        int count = 1;
        String out = "";
        for (int index = 1; index < dpGlobalFormat.length(); ++index) {
            char current = dpGlobalFormat.charAt(index);
            if (current == last) {
                ++count;
                continue;
            }
            out = out + this.processToken(last, count);
            last = current;
            count = 1;
        }
        out = out + this.processToken(last, count);
        return out;
    }

    private String processToken(char token, int count) {
        if (token == 'y') {
            if (count == 2) {
                return "yy";
            }
            if (count == 4) {
                return "yyyy";
            }
        } else if (token == 'm') {
            if (count == 1) {
                return "M";
            }
            if (count == 2) {
                return "MM";
            }
        } else if (token == 'M') {
            if (count == 1) {
                return "MMM";
            }
            if (count == 2) {
                return "MMMM";
            }
        } else if (token == 'h') {
            token = (char)72;
        } else if (token == 'i') {
            token = (char)109;
        }
        String out = "";
        for (int i = 0; i < count; ++i) {
            out = out + token;
        }
        return out;
    }
}

