/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui.resources;

import com.github.gwtbootstrap.client.ui.config.Configurator;
import com.github.gwtbootstrap.client.ui.resources.JavaScriptInjector;
import com.github.gwtbootstrap.client.ui.resources.MetaInjector;
import com.github.gwtbootstrap.client.ui.resources.Resources;
import com.github.gwtbootstrap.client.ui.resources.internal.InternalResourceInjector;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadElement;
import com.google.gwt.dom.client.LinkElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.StyleInjector;
import com.google.gwt.resources.client.TextResource;

public class ResourceInjector {
    private static final Configurator ADAPTER = (Configurator)GWT.create(Configurator.class);
    private static final InternalResourceInjector INJECTOR = (InternalResourceInjector)GWT.create(InternalResourceInjector.class);
    private static HeadElement head;

    public static void configureWithCssFile() {
        ResourceInjector.injectResourceCssAsFile("bootstrap.min.css");
        ResourceInjector.injectResourceCssAsFile("gwt-bootstrap.css");
        ResourceInjector.injectResourceCssAsFile("font-awesome.min.css");
        ResourceInjector.configure();
    }

    public static void configure() {
        INJECTOR.preConfigure();
        Resources res = ADAPTER.getResources();
        if (ResourceInjector.isNotLoadedJquery()) {
            ResourceInjector.injectJs(res.jquery());
        }
        ResourceInjector.injectJs(res.bootstrapJs());
        if (ADAPTER.hasResponsiveDesign()) {
            ResourceInjector.activateResponsiveDesign(res);
        }
        INJECTOR.configure();
    }

    private static native boolean isNotLoadedJquery();

    private static void injectCss(TextResource r) {
        StyleInjector.inject((String)r.getText());
    }

    public static void injectResourceCssAsFile(String filename) {
        LinkElement link = Document.get().createLinkElement();
        link.setType("text/css");
        link.setRel("stylesheet");
        link.setHref(GWT.getModuleName() + "/css/" + filename);
        ResourceInjector.getHead().appendChild((Node)link);
    }

    private static HeadElement getHead() {
        if (head == null) {
            Element elt = (Element)Document.get().getElementsByTagName("head").getItem(0);
            assert (elt != null) : "The host HTML page does not have a <head> element which is required by StyleInjector";
            head = HeadElement.as((Element)elt);
        }
        return head;
    }

    private static void injectJs(TextResource r) {
        JavaScriptInjector.inject(r.getText());
    }

    private static void activateResponsiveDesign(Resources res) {
        ResourceInjector.injectCss(res.bootstrapResponsiveCss());
        MetaInjector.inject("viewport", "width=device-width, initial-scale=1.0");
    }
}

