/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui.base;

import com.github.gwtbootstrap.client.ui.base.HasStyle;
import com.github.gwtbootstrap.client.ui.constants.Device;
import com.github.gwtbootstrap.client.ui.constants.ResponsiveStyle;

public class ResponsiveHelper {
    public static <T extends HasStyle> void setShowOn(T widget, Device device) {
        ResponsiveHelper.removeResponsiveStyles(widget);
        switch (device) {
            case PHONE: {
                widget.addStyle(ResponsiveStyle.VISIBLE_PHONE);
                break;
            }
            case TABLET: {
                widget.addStyle(ResponsiveStyle.VISIBLE_TABLET);
                break;
            }
            case DESKTOP: {
                widget.addStyle(ResponsiveStyle.VISIBLE_DESKTOP);
            }
        }
    }

    public static <T extends HasStyle> void setHideOn(T widget, Device device) {
        ResponsiveHelper.removeResponsiveStyles(widget);
        switch (device) {
            case PHONE: {
                widget.addStyle(ResponsiveStyle.HIDDEN_PHONE);
                break;
            }
            case TABLET: {
                widget.addStyle(ResponsiveStyle.HIDDEN_TABLET);
                break;
            }
            case DESKTOP: {
                widget.addStyle(ResponsiveStyle.HIDDEN_DESKTOP);
            }
        }
    }

    private static <T extends HasStyle> void removeResponsiveStyles(T element) {
        element.removeStyle(ResponsiveStyle.VISIBLE_PHONE);
        element.removeStyle(ResponsiveStyle.VISIBLE_TABLET);
        element.removeStyle(ResponsiveStyle.VISIBLE_DESKTOP);
        element.removeStyle(ResponsiveStyle.HIDDEN_PHONE);
        element.removeStyle(ResponsiveStyle.HIDDEN_TABLET);
        element.removeStyle(ResponsiveStyle.HIDDEN_DESKTOP);
    }
}

