/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui.base;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.base.Caret;
import com.github.gwtbootstrap.client.ui.base.ComplexWidget;
import com.github.gwtbootstrap.client.ui.base.HasHref;
import com.github.gwtbootstrap.client.ui.base.HasIcon;
import com.github.gwtbootstrap.client.ui.base.TextNode;
import com.github.gwtbootstrap.client.ui.constants.BaseIconType;
import com.github.gwtbootstrap.client.ui.constants.IconPosition;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Text;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.FocusImpl;

public class IconAnchor
extends ComplexWidget
implements HasText,
HasIcon,
HasHref,
HasClickHandlers,
HasEnabled,
Focusable,
HasName,
HasMouseDownHandlers {
    private static final FocusImpl impl = FocusImpl.getFocusImplForWidget();
    protected Icon icon = new Icon();
    private TextNode text = new TextNode("");
    private Caret caret = new Caret();
    private IconPosition iconPosition;

    public IconAnchor() {
        super("a");
        this.setIconPosition(IconPosition.LEFT);
        this.setEmptyHref();
    }

    @Override
    public void setIconPosition(IconPosition position) {
        this.iconPosition = position;
        this.icon.removeFromParent();
        this.text.removeFromParent();
        if (IconPosition.RIGHT == position) {
            this.insert(this.text, 0);
            this.insert(this.icon, 1);
            return;
        }
        if (IconPosition.LEFT == position) {
            this.insert(this.icon, 0);
            this.insert(this.text, 1);
            return;
        }
    }

    @Override
    public void setIcon(IconType type) {
        this.setBaseIcon(type);
    }

    @Override
    public void setBaseIcon(BaseIconType type) {
        this.icon.setBaseType(type);
    }

    @Override
    public void setIconSize(IconSize size) {
        this.icon.setIconSize(size);
    }

    public void setText(String text) {
        if (!this.getElement().isOrHasChild((Node)this.text.getElement())) {
            Text toRemove = null;
            for (int i = 0; i < this.getElement().getChildCount(); ++i) {
                Text t;
                Node n = this.getElement().getChildNodes().getItem(i);
                if (n.getNodeType() != 3 || !(t = (Text)n.cast()).getNodeValue().equals(this.text.getText()) && !t.getNodeValue().equals(text)) continue;
                toRemove = t;
            }
            if (toRemove != null) {
                this.getElement().removeChild(toRemove);
            }
            this.getElement().appendChild((Node)this.text.getElement());
        }
        this.text.removeFromParent();
        this.text = new TextNode(" " + text + " ");
        this.setIconPosition(this.iconPosition);
    }

    public String getText() {
        return this.text.getText();
    }

    @Override
    public void setHref(String href) {
        this.getElement().setAttribute("href", href);
    }

    @Override
    public String getHref() {
        return this.getElement().getAttribute("href");
    }

    public void setCaret(boolean visible) {
        if (visible) {
            super.add(this.caret);
        } else {
            super.remove((Widget)this.caret);
        }
    }

    @Override
    public void setTargetHistoryToken(String targetHistoryToken) {
        this.setHref("#" + targetHistoryToken);
    }

    @Override
    public String getTargetHistoryToken() {
        String[] hrefs = this.getHref().split("#");
        return hrefs[1];
    }

    public void setEmptyHref() {
        this.setHref("javascript:;");
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseDownEvent.getType());
    }

    public boolean isEnabled() {
        return !DOM.getElementPropertyBoolean((Element)this.getElement(), (String)"disabled");
    }

    public void setEnabled(boolean enabled) {
        DOM.setElementPropertyBoolean((Element)this.getElement(), (String)"disabled", (!enabled ? 1 : 0) != 0);
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 1: {
                if (!this.isEnabled()) break;
                super.onBrowserEvent(event);
                break;
            }
            default: {
                super.onBrowserEvent(event);
            }
        }
    }

    public int getTabIndex() {
        return impl.getTabIndex(this.getElement());
    }

    public void setAccessKey(char key) {
        DOM.setElementProperty((Element)this.getElement(), (String)"accessKey", (String)("" + key));
    }

    public void setFocus(boolean focused) {
        if (focused) {
            impl.focus(this.getElement());
        } else {
            impl.blur(this.getElement());
        }
    }

    public void setTabIndex(int index) {
        impl.setTabIndex(this.getElement(), index);
    }

    protected void onAttach() {
        super.onAttach();
        int tabIndex = this.getTabIndex();
        if (-1 == tabIndex) {
            this.setTabIndex(0);
        }
    }

    public void setActive(boolean active) {
        this.setStyleName("active", active);
    }

    public boolean isActive() {
        return this.getStyleName().contains("active");
    }

    public void setName(String name) {
        this.getAnchorElement().setName(name);
    }

    public String getName() {
        return this.getAnchorElement().getName();
    }

    public void setTarget(String target) {
        this.getAnchorElement().setTarget(target);
    }

    public String getTarget() {
        return this.getAnchorElement().getTarget();
    }

    protected AnchorElement getAnchorElement() {
        return AnchorElement.as((Element)this.getElement());
    }

    @Override
    public void setCustomIconStyle(String customIconStyle) {
        this.icon.addStyleName(customIconStyle);
    }
}

