/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui.base;

import com.github.gwtbootstrap.client.ui.base.HasPlacement;
import com.github.gwtbootstrap.client.ui.base.HasShowDelay;
import com.github.gwtbootstrap.client.ui.base.HasTrigger;
import com.github.gwtbootstrap.client.ui.base.HasVisibility;
import com.github.gwtbootstrap.client.ui.base.IsAnimated;
import com.github.gwtbootstrap.client.ui.base.MarkupWidget;
import com.github.gwtbootstrap.client.ui.constants.Placement;
import com.github.gwtbootstrap.client.ui.constants.Trigger;
import com.github.gwtbootstrap.client.ui.constants.VisibilityChange;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.HasOneWidget;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;

public abstract class HoverBase
extends MarkupWidget
implements IsWidget,
HasWidgets,
HasOneWidget,
IsAnimated,
HasTrigger,
HasPlacement,
HasText,
HasShowDelay,
HasVisibility {
    protected boolean animated = true;
    protected Placement placement = Placement.TOP;
    protected Trigger trigger = Trigger.HOVER;
    protected int showDelayInMilliseconds = 0;
    protected int hideDelayInMilliseconds = 0;
    protected String container;

    @Override
    public Widget asWidget() {
        if (this.getWidget() != null) {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    HoverBase.this.removeDataIfExists();
                    HoverBase.this.reconfigure();
                    HoverBase.this.getWidget().addAttachHandler(new AttachEvent.Handler(){

                        public void onAttachOrDetach(AttachEvent event) {
                            if (!event.isAttached()) {
                                HoverBase.this.changeVisibility(VisibilityChange.HIDE);
                            }
                        }
                    });
                }
            });
        }
        return this.getWidget();
    }

    protected void removeDataIfExists() {
        this.hide();
        this.removeDataIfExists(this.getWidget().getElement(), this.getDataName());
    }

    protected abstract void removeDataIfExists(Element var1, String var2);

    protected void setDataAttribute(Element e, String attribute, String value) {
        e.setAttribute("data-" + attribute, value);
    }

    @Override
    public void setAnimation(boolean animated) {
        this.animated = animated;
    }

    public abstract void reconfigure();

    @Override
    public boolean getAnimation() {
        return this.animated;
    }

    @Override
    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    @Override
    public Placement getPlacement() {
        return this.placement;
    }

    @Override
    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    @Override
    public Trigger getTrigger() {
        return this.trigger;
    }

    @Override
    public void setShowDelay(int delayInMilliseconds) {
        this.showDelayInMilliseconds = delayInMilliseconds;
    }

    @Override
    public int getShowDelay() {
        return this.showDelayInMilliseconds;
    }

    @Override
    public void setHideDelay(int delayInMilliseconds) {
        this.hideDelayInMilliseconds = delayInMilliseconds;
    }

    @Override
    public int getHideDelay() {
        return this.hideDelayInMilliseconds;
    }

    @Override
    public void show() {
        this.changeVisibility(VisibilityChange.SHOW);
    }

    @Override
    public void hide() {
        this.changeVisibility(VisibilityChange.HIDE);
    }

    @Override
    public void toggle() {
        this.changeVisibility(VisibilityChange.TOGGLE);
    }

    protected abstract void changeVisibility(VisibilityChange var1);

    protected abstract String getDataName();

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }
}

