/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui.base;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.base.ComplexWidget;
import com.github.gwtbootstrap.client.ui.base.HasIcon;
import com.github.gwtbootstrap.client.ui.constants.BaseIconType;
import com.github.gwtbootstrap.client.ui.constants.IconPosition;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.IsWidget;

public class AddOn
extends ComplexWidget
implements HasText,
HasIcon {
    private String text;
    private Icon icon = new Icon();

    public AddOn() {
        super("span");
        this.setStyleName("add-on");
    }

    public String getText() {
        return this.getElement().getInnerText();
    }

    public void setText(String text) {
        this.text = text;
        if (this.icon.isAttached()) {
            this.icon.removeFromParent();
        }
        this.getElement().setInnerText(text);
    }

    @Override
    public void setIcon(IconType type) {
        this.setBaseIcon(type);
    }

    @Override
    public void setBaseIcon(BaseIconType type) {
        if (this.text != null) {
            this.getElement().setInnerHTML("");
        }
        this.icon.setBaseType(type);
        if (!this.icon.isAttached()) {
            this.add(this.icon);
        }
    }

    @Override
    public void setIconSize(IconSize size) {
        this.icon.setIconSize(size);
    }

    @UiChild(tagname="widget", limit=1)
    public void addWidget(IsWidget w) {
        this.add(w);
    }

    @Override
    public void setCustomIconStyle(String customIconStyle) {
        this.icon.addStyleName(customIconStyle);
    }

    @Override
    @Deprecated
    public void setIconPosition(IconPosition position) {
        throw new UnsupportedOperationException("Addon does not support this methods");
    }
}

