/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.MarkupWidget;
import com.github.gwtbootstrap.client.ui.base.TextBoxBase;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;

public class Typeahead
extends MarkupWidget {
    private int displayItems = 8;
    private int minLength = 1;
    private final SuggestOracle oracle;
    private Collection<? extends SuggestOracle.Suggestion> suggestions;
    private UpdaterCallback updaterCallback;
    private HighlighterCallback highlighterCallback;
    private MatcherCallback matcherCallback;

    public Typeahead() {
        this((SuggestOracle)new MultiWordSuggestOracle());
    }

    public Typeahead(SuggestOracle oracle) {
        this.oracle = oracle;
        this.updaterCallback = this.createDefaultUpdaterCallback();
        this.highlighterCallback = this.createDefaultHighlighterCallback();
        this.matcherCallback = this.createDefaultMatcherCallback();
    }

    private UpdaterCallback createDefaultUpdaterCallback() {
        return new UpdaterCallback(){

            @Override
            public String onSelection(SuggestOracle.Suggestion selectedSuggestion) {
                return selectedSuggestion.getReplacementString();
            }
        };
    }

    private HighlighterCallback createDefaultHighlighterCallback() {
        return new HighlighterCallback(){

            @Override
            public String highlight(String item) {
                return item;
            }
        };
    }

    private MatcherCallback createDefaultMatcherCallback() {
        return new MatcherCallback(){

            @Override
            public boolean compareQueryToItem(String query, String item) {
                return item.toLowerCase().contains(query.toLowerCase());
            }
        };
    }

    @Override
    public void setWidget(Widget w) {
        if (!(w instanceof TextBoxBase) && !(w instanceof com.google.gwt.user.client.ui.TextBoxBase)) {
            throw new IllegalArgumentException("Typeahead should be set TextBoxBase childs");
        }
        super.setWidget(w);
    }

    @Override
    public Widget asWidget() {
        if (this.widget != null) {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    Typeahead.this.reconfigure();
                }
            });
        }
        return super.asWidget();
    }

    public void reconfigure() {
        if (this.widget == null) {
            return;
        }
        this.removeDataIfExists(this.widget.getElement());
        this.configure(this.widget.getElement(), this.displayItems, this.minLength);
    }

    public int getDisplayItemCount() {
        return this.displayItems;
    }

    public void setDisplayItemCount(int displayItems) {
        this.displayItems = displayItems;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setUpdaterCallback(UpdaterCallback updaterCallback) {
        this.updaterCallback = updaterCallback;
    }

    public void setHighlighterCallback(HighlighterCallback highlighterCallback) {
        this.highlighterCallback = highlighterCallback;
    }

    public void setMatcherCallback(MatcherCallback matcherCallback) {
        this.matcherCallback = matcherCallback;
    }

    public SuggestOracle getSuggestOracle() {
        return this.oracle;
    }

    private void query(String query, final JavaScriptObject process) {
        SuggestOracle.Callback callback = new SuggestOracle.Callback(){

            public void onSuggestionsReady(SuggestOracle.Request request, SuggestOracle.Response response) {
                Typeahead.this.callback(process, response);
            }
        };
        if (query != null && !query.isEmpty()) {
            this.oracle.requestSuggestions(new SuggestOracle.Request(query, this.displayItems), callback);
        } else {
            this.oracle.requestDefaultSuggestions(new SuggestOracle.Request(), callback);
        }
    }

    private void callback(JavaScriptObject process, SuggestOracle.Response response) {
        this.suggestions = response.getSuggestions();
        JsArrayString jsArrayString = (JsArrayString)JavaScriptObject.createArray().cast();
        for (SuggestOracle.Suggestion suggestion : this.suggestions) {
            jsArrayString.push(suggestion.getDisplayString());
        }
        this.callProcess(jsArrayString, process);
    }

    private String updater(String item) {
        for (SuggestOracle.Suggestion suggestion : this.suggestions) {
            if (!suggestion.getDisplayString().equals(item)) continue;
            return this.updaterCallback.onSelection(suggestion);
        }
        return item;
    }

    private String highlighter(String item) {
        return this.highlighterCallback.highlight(item);
    }

    private boolean selectionMatcher(String query, String item) {
        return this.matcherCallback.compareQueryToItem(query, item);
    }

    private native void callProcess(JsArrayString var1, JavaScriptObject var2);

    private native void removeDataIfExists(Element var1);

    public native void configure(Element var1, int var2, int var3);

    public static interface MatcherCallback {
        public boolean compareQueryToItem(String var1, String var2);
    }

    public static interface HighlighterCallback {
        public String highlight(String var1);
    }

    public static interface UpdaterCallback {
        public String onSelection(SuggestOracle.Suggestion var1);
    }
}

