/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.DropdownTab;
import com.github.gwtbootstrap.client.ui.NavTabs;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabLink;
import com.github.gwtbootstrap.client.ui.TabPane;
import com.github.gwtbootstrap.client.ui.base.DivWidget;
import com.github.gwtbootstrap.client.ui.resources.Bootstrap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class TabPanel
extends DivWidget {
    private NavTabs tabs = new NavTabs();
    private List<TabLink> tabLinkList = new ArrayList<TabLink>();
    private TabContent tabContent = new TabContent();

    public TabPanel() {
        this(Bootstrap.Tabs.ABOVE);
    }

    public TabPanel(Bootstrap.Tabs position) {
        this.setStyle(position);
        if (Bootstrap.Tabs.BELOW == position) {
            super.add((Widget)this.tabContent);
            super.add((Widget)this.tabs);
        } else {
            super.add((Widget)this.tabs);
            super.add((Widget)this.tabContent);
        }
        this.setHandlerFunctions(this.getElement());
    }

    public void setTabPosition(String position) {
        if (this.tabs.getParent() != null) {
            this.remove((Widget)this.tabs);
            this.remove((Widget)this.tabContent);
        }
        if (position.equalsIgnoreCase("below")) {
            this.setStyle(Bootstrap.Tabs.BELOW);
            super.add((Widget)this.tabContent);
            super.add((Widget)this.tabs);
        } else if (position.equalsIgnoreCase("left")) {
            this.setStyle(Bootstrap.Tabs.LEFT);
            super.add((Widget)this.tabs);
            super.add((Widget)this.tabContent);
        } else if (position.equalsIgnoreCase("right")) {
            this.setStyle(Bootstrap.Tabs.RIGHT);
            super.add((Widget)this.tabs);
            super.add((Widget)this.tabContent);
        } else {
            this.setStyle(Bootstrap.Tabs.ABOVE);
            super.add((Widget)this.tabs);
            super.add((Widget)this.tabContent);
        }
    }

    public void add(Widget child) {
        if (child instanceof TabPane) {
            this.add((TabPane)child);
            return;
        }
        if (child instanceof TabLink) {
            this.add((TabLink)child);
            return;
        }
        if (child instanceof DropdownTab) {
            this.add((DropdownTab)child);
            return;
        }
        if (GWT.isProdMode()) {
            throw new IllegalArgumentException("TabPanel can add only TabPane or TabLink or Tab or DorpdownTab. you added " + child);
        }
    }

    private void add(DropdownTab dropdownTab) {
        this.tabs.add((Widget)dropdownTab);
        List<Tab> tabList = dropdownTab.getTabList();
        for (Tab tab : tabList) {
            this.tabLinkList.add(tab.asTabLink());
            TabPane tabPane = tab.getTabPane();
            this.tabContent.add((Widget)tabPane);
        }
    }

    private void add(TabPane child) {
        if (child.isCreateTabLink()) {
            TabLink tabLink = new TabLink(child);
            this.tabs.add((Widget)tabLink);
            this.tabLinkList.add(tabLink);
        }
        this.tabContent.add((Widget)child);
    }

    private void add(TabLink child) {
        if (child.isCreateTabPane() && child.getTabPane() == null) {
            TabPane pane = new TabPane(child.getText());
            child.setTabPane(pane);
            this.tabContent.add((Widget)pane);
        } else if (child.getTabPane() != null) {
            this.tabContent.add((Widget)child.getTabPane());
        }
        this.tabs.add((Widget)child);
        this.tabLinkList.add(child);
    }

    public void clear() {
        this.tabContent.clear();
        this.tabs.clear();
        this.tabLinkList.clear();
    }

    public boolean remove(int index) {
        Widget widget = this.tabs.getWidget(index);
        if (widget instanceof TabLink) {
            TabLink link = (TabLink)widget;
            if (link.getTabPane() != null) {
                link.getTabPane().removeFromParent();
            }
            this.tabLinkList.remove(link);
            return this.tabs.remove(index);
        }
        if (widget instanceof DropdownTab) {
            DropdownTab dropdownTab = (DropdownTab)widget;
            List<Tab> tabList = dropdownTab.getTabList();
            for (Tab tab : tabList) {
                this.tabLinkList.remove(tab.asTabLink());
                if (tab.getTabPane() == null) continue;
                tab.getTabPane().removeFromParent();
            }
            return this.tabs.remove((Widget)dropdownTab);
        }
        if (widget instanceof TabPane) {
            return this.tabContent.remove(widget);
        }
        return super.remove(widget);
    }

    public boolean remove(Widget w) {
        if (w instanceof TabLink) {
            TabLink link = (TabLink)w;
            this.tabLinkList.remove(link);
            if (link.getTabPane() != null) {
                link.getTabPane().removeFromParent();
            }
            return this.tabs.remove(w);
        }
        if (w instanceof DropdownTab) {
            DropdownTab dropdownTab = (DropdownTab)w;
            List<Tab> tabList = dropdownTab.getTabList();
            for (Tab tab : tabList) {
                this.tabLinkList.remove(tab.asTabLink());
                if (tab.getTabPane() == null) continue;
                tab.getTabPane().removeFromParent();
            }
            return this.tabs.remove((Widget)dropdownTab);
        }
        if (w instanceof TabPane) {
            return this.tabContent.remove(w);
        }
        return super.remove(w);
    }

    public boolean remove(IsWidget child) {
        if (child instanceof Tab) {
            Tab tab = (Tab)child;
            TabLink link = tab.asTabLink();
            if (link.getTabPane() != null) {
                link.getTabPane().removeFromParent();
            }
            this.tabLinkList.remove(link);
            return this.tabs.remove((Widget)link);
        }
        if (child instanceof DropdownTab) {
            DropdownTab tab = (DropdownTab)child;
            List<Tab> tabList = tab.getTabList();
            for (Tab tab2 : tabList) {
                this.tabLinkList.remove(tab2.asTabLink());
                if (tab2.getTabPane() == null) continue;
                this.tabContent.remove((Widget)tab2.getTabPane());
            }
            return super.remove(child);
        }
        return super.remove(child);
    }

    public void selectTab(int index) {
        this.tabLinkList.get(index).show();
    }

    public int getSelectedTab() {
        for (int i = 0; i < this.tabLinkList.size(); ++i) {
            if (!this.tabLinkList.get(i).isActive()) continue;
            return i;
        }
        return -1;
    }

    private void setHandlerFunctions(final TabLink e) {
        if (this.isOrWasAttached()) {
            this.setHandlerFunctions(e.getAnchor().getElement());
            return;
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                TabPanel.this.setHandlerFunctions(e.getAnchor().getElement());
            }
        });
    }

    protected void onShow(Event e, Element target, Element relatedTarget) {
        ShowEvent event = new ShowEvent((NativeEvent)e);
        event.setTarget(this.findTabLink(target));
        event.setRelatedTarget(this.findTabLink(relatedTarget));
        this.fireEvent((GwtEvent)event);
    }

    protected void onShown(Event e, Element target, Element relatedTarget) {
        ShownEvent event = new ShownEvent((NativeEvent)e);
        event.setTarget(this.findTabLink(target));
        event.setRelatedTarget(this.findTabLink(relatedTarget));
        this.fireEvent((GwtEvent)event);
    }

    public HandlerRegistration addShowHandler(ShowEvent.Handler handler) {
        return this.addHandler(handler, (GwtEvent.Type)ShowEvent.TYPE);
    }

    public HandlerRegistration addShownHandler(ShownEvent.Handler handler) {
        return this.addHandler(handler, (GwtEvent.Type)ShownEvent.TYPE);
    }

    private TabLink findTabLink(Element e) {
        for (TabLink tabLink : this.tabLinkList) {
            if (!tabLink.getAnchor().getElement().equals((Object)e)) continue;
            return tabLink;
        }
        return null;
    }

    private void setHandlerFunctions(Element e) {
    }

    private static class TabContent
    extends DivWidget {
        public TabContent() {
            this.setStyleName("tab-content");
        }
    }

    public static class ShownEvent
    extends DomEvent<Handler> {
        private static final DomEvent.Type<Handler> TYPE = new DomEvent.Type("shown", (DomEvent)new ShownEvent());
        private TabLink target;
        private TabLink relatedTarget;

        protected ShownEvent() {
        }

        public ShownEvent(NativeEvent event) {
            this.setNativeEvent(event);
            if (Element.is((JavaScriptObject)event.getRelatedEventTarget())) {
                this.setRelativeElement(Element.as((JavaScriptObject)event.getRelatedEventTarget()));
            }
        }

        protected void dispatch(Handler handler) {
            handler.onShow(this);
        }

        public DomEvent.Type<Handler> getAssociatedType() {
            return TYPE;
        }

        public TabLink getTarget() {
            return this.target;
        }

        public void setTarget(TabLink target) {
            this.target = target;
        }

        public TabLink getRelatedTarget() {
            return this.relatedTarget;
        }

        public void setRelatedTarget(TabLink relatedTarget) {
            this.relatedTarget = relatedTarget;
        }

        public static interface Handler
        extends EventHandler {
            public void onShow(ShownEvent var1);
        }
    }

    public static class ShowEvent
    extends DomEvent<Handler> {
        private static final DomEvent.Type<Handler> TYPE = new DomEvent.Type("show", (DomEvent)new ShowEvent());
        private TabLink target;
        private TabLink relatedTarget;

        protected ShowEvent() {
        }

        public ShowEvent(NativeEvent event) {
            this.setNativeEvent(event);
            if (Element.is((JavaScriptObject)event.getRelatedEventTarget())) {
                this.setRelativeElement(Element.as((JavaScriptObject)event.getRelatedEventTarget()));
            }
        }

        protected void dispatch(Handler handler) {
            handler.onShow(this);
        }

        public DomEvent.Type<Handler> getAssociatedType() {
            return TYPE;
        }

        public TabLink getTarget() {
            return this.target;
        }

        public void setTarget(TabLink target) {
            this.target = target;
        }

        public TabLink getRelatedTarget() {
            return this.relatedTarget;
        }

        public void setRelatedTarget(TabLink relatedTarget) {
            this.relatedTarget = relatedTarget;
        }

        public static interface Handler
        extends EventHandler {
            public void onShow(ShowEvent var1);
        }
    }
}

