/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.NavWidget;
import com.github.gwtbootstrap.client.ui.TabPane;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.HasEnabled;

public class TabLink
extends NavWidget
implements HasEnabled {
    private TabPane pane;
    private boolean createTabPane = true;
    private boolean enabled = true;

    public TabLink(TabPane pane) {
        this();
        this.setText(pane.getHeading());
        this.setTabPane(pane);
    }

    public TabLink() {
        this.getAnchor().getElement().setAttribute("data-toggle", "tab");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled && !this.enabled) {
            this.enabled = true;
            this.getAnchor().getElement().setAttribute("data-toggle", "tab");
            this.removeStyleName("disabled");
        } else if (!enabled && this.enabled) {
            this.enabled = false;
            this.getAnchor().getElement().removeAttribute("data-toggle");
            this.addStyleName("disabled");
        }
    }

    public void setCreateTabPane(boolean createTabPane) {
        this.createTabPane = createTabPane;
    }

    public boolean isCreateTabPane() {
        return this.createTabPane;
    }

    public void setTabPane(TabPane pane) {
        this.pane = pane;
        if (pane.getId() == null || pane.getId().isEmpty()) {
            pane.setHref(DOM.createUniqueId());
        }
        this.setDataTarget(pane.getId());
        this.setActive(pane.isActive());
    }

    public void setDataTarget(String id) {
        this.getAnchor().getElement().setAttribute("data-target", "#" + id);
    }

    public TabPane getTabPane() {
        return this.pane;
    }

    protected void onAttach() {
        super.onAttach();
        if (this.isActive()) {
            this.show();
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.pane != null) {
            this.pane.setActive(active);
        }
    }

    public void show() {
        if (this.isOrWasAttached()) {
            this.show(this.getAnchor().getElement());
            return;
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                TabLink.this.show(TabLink.this.getAnchor().getElement());
            }
        });
    }

    private void show(Element e) {
    }
}

