/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.Pagination;
import com.github.gwtbootstrap.client.ui.base.HasId;
import com.github.gwtbootstrap.client.ui.base.HasStyle;
import com.github.gwtbootstrap.client.ui.base.IsResponsive;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.constants.Device;
import com.github.gwtbootstrap.client.ui.constants.IconPosition;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.AbstractPager;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasRows;
import com.google.web.bindery.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.List;

public class NumberedPager
extends AbstractPager
implements HasStyle,
IsResponsive,
HasId {
    private final Pagination pagination = new Pagination();
    private final List<HandlerRegistration> handlerRegistrationList = new ArrayList<HandlerRegistration>();
    private int visiblePages = -1;
    private String nextCustomStyleName;
    private String previousCustomStyleName;
    private NavLink nextLink = new NavLink(">");
    private NavLink previousLink = new NavLink("<");

    public NumberedPager() {
        this.initWidget((Widget)this.pagination);
    }

    @Override
    public String getId() {
        return this.pagination.getId();
    }

    @Override
    public void setId(String id) {
        this.pagination.setId(id);
    }

    public void setPullRight(boolean pullRight) {
        this.pagination.setPullRight(pullRight);
    }

    public void setAlignment(String alignment) {
        this.pagination.setAlignment(alignment);
    }

    public void setVisiblePages(int visiblePages) {
        this.visiblePages = visiblePages;
        if (visiblePages > 0) {
            this.setRangeLimited(false);
        }
    }

    @Override
    public void setShowOn(Device device) {
        this.pagination.setShowOn(device);
    }

    @Override
    public void setHideOn(Device device) {
        this.pagination.setHideOn(device);
    }

    public void setSize(Pagination.PaginationSize size) {
        this.pagination.setSize(size);
    }

    @Override
    public void setStyle(Style style) {
        this.pagination.setStyle(style);
    }

    @Override
    public void addStyle(Style style) {
        this.pagination.addStyle(style);
    }

    @Override
    public void removeStyle(Style style) {
        this.pagination.removeStyle(style);
    }

    public void setNextCustomStyleName(String nextCustomStyleName) {
        this.nextCustomStyleName = nextCustomStyleName;
    }

    public void setNextText(String nextText) {
        this.nextLink.setText(nextText);
    }

    public void setNextIcon(IconType type) {
        this.nextLink.setIcon(type);
    }

    public void setNextCustomIconStyle(String customIconStyle) {
        this.nextLink.setCustomIconStyle(customIconStyle);
    }

    public void setNextIconPosition(IconPosition position) {
        this.nextLink.setIconPosition(position);
    }

    public void setNextIconSize(IconSize size) {
        this.nextLink.setIconSize(size);
    }

    public void setPreviousCustomStyleName(String previousCustomStyleName) {
        this.previousCustomStyleName = previousCustomStyleName;
    }

    public void setPreviousText(String previousText) {
        this.previousLink.setText(previousText);
    }

    public void setPreviousIcon(IconType type) {
        this.previousLink.setIcon(type);
    }

    public void setPreviousCustomIconStyle(String customIconStyle) {
        this.previousLink.setCustomIconStyle(customIconStyle);
    }

    public void setPreviousIconPosition(IconPosition position) {
        this.previousLink.setIconPosition(position);
    }

    public void setPreviousIconSize(IconSize size) {
        this.previousLink.setIconSize(size);
    }

    protected void onRangeOrRowCountChanged() {
        HasRows display = super.getDisplay();
        int pageSize = super.getPageSize();
        int calculatedPage = display.getVisibleRange().getStart() / pageSize;
        int pageCount = super.getPageCount();
        if (pageCount > 0 && calculatedPage != super.getPage()) {
            display.setVisibleRange(pageSize * calculatedPage, pageSize);
        } else if (pageCount > 0) {
            int widgetCount;
            if (this.pagination.getWidgetCount() == 0) {
                this.initPagination();
            }
            if (pageCount + 2 > (widgetCount = this.pagination.getWidgetCount())) {
                for (int i = widgetCount - 1; i <= pageCount; ++i) {
                    NavLink page = this.pagination.addPageLink(i);
                    page.addClickHandler(this.createPageClickHandler(i - 1));
                }
            } else if (pageCount + 2 < widgetCount) {
                for (int i = widgetCount - 2; i > pageCount; --i) {
                    this.pagination.remove(i);
                }
            }
            this.updateButtonsState();
        } else if (this.pagination.getWidgetCount() > 0) {
            this.resetPagination();
        }
    }

    private void initPagination() {
        if (this.previousCustomStyleName != null) {
            this.previousLink.addStyleName(this.previousCustomStyleName);
        }
        this.handlerRegistrationList.add((HandlerRegistration)this.previousLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NumberedPager.this.previousPage();
            }
        }));
        this.pagination.add((Widget)this.previousLink);
        NavLink page = this.pagination.addPageLink(1);
        page.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NumberedPager.this.setPage(0);
            }
        });
        page.setDisabled(true);
        if (this.nextCustomStyleName != null) {
            this.nextLink.addStyleName(this.nextCustomStyleName);
        }
        this.handlerRegistrationList.add((HandlerRegistration)this.nextLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NumberedPager.this.nextPage();
            }
        }));
        this.pagination.add((Widget)this.nextLink);
    }

    private void updateButtonsState() {
        int pageCount = this.getPageCount();
        int currentPage = this.getPage();
        if (this.visiblePages > 0) {
            int i;
            int maxPages = this.visiblePages < pageCount ? this.visiblePages : pageCount;
            int pagesToShow = Math.min(pageCount, maxPages);
            int firstVisibleIndex = 1;
            if (currentPage >= pageCount - maxPages / 2) {
                firstVisibleIndex = pageCount - maxPages + 1;
            } else if (currentPage > maxPages / 2) {
                firstVisibleIndex = currentPage - maxPages / 2 + 1;
            }
            int firstNotVisibleIndex = pagesToShow + firstVisibleIndex;
            for (i = 1; i < firstVisibleIndex; ++i) {
                this.pagination.getWidget(i).setVisible(false);
            }
            for (i = firstNotVisibleIndex; i < this.pagination.getWidgetCount() - 1; ++i) {
                this.pagination.getWidget(i).setVisible(false);
            }
            for (i = firstVisibleIndex; i < firstNotVisibleIndex; ++i) {
                this.pagination.getWidget(i).setVisible(true);
            }
        }
        for (int i = 1; i < this.pagination.getWidgetCount() - 1; ++i) {
            NavLink navLink = (NavLink)this.pagination.getWidget(i);
            navLink.setDisabled(false);
            navLink.setActive(false);
        }
        NavLink navLink = (NavLink)this.pagination.getWidget(currentPage + 1);
        navLink.setDisabled(true);
        navLink.setActive(true);
        this.updatePreviousAndNextButtons();
    }

    private void updatePreviousAndNextButtons() {
        this.previousLink.setDisabled(!super.hasPreviousPage());
        this.nextLink.setDisabled(!super.hasNextPage());
    }

    private ClickHandler createPageClickHandler(final int page) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                NumberedPager.this.setPage(page);
            }
        };
    }

    private void resetPagination() {
        for (HandlerRegistration handlerRegistration : this.handlerRegistrationList) {
            handlerRegistration.removeHandler();
        }
        this.pagination.clear();
        if (this.previousCustomStyleName != null) {
            this.previousLink.removeStyleName(this.previousCustomStyleName);
        }
        if (this.nextCustomStyleName != null) {
            this.nextLink.removeStyleName(this.nextCustomStyleName);
        }
    }
}

