/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Container;
import com.github.gwtbootstrap.client.ui.Scrollspy;
import com.github.gwtbootstrap.client.ui.base.DivWidget;
import com.github.gwtbootstrap.client.ui.constants.NavbarPosition;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;

public class Navbar
extends DivWidget {
    private final Container container = this.getContainer();
    private final NavbarInner navbarInner = new NavbarInner();
    private Scrollspy spy;
    private boolean scrollspy;

    public Navbar() {
        this.setStyleName("navbar");
        this.navbarInner.add((Widget)this.container);
        super.add((Widget)this.navbarInner);
        this.setId(Document.get().createUniqueId());
    }

    @Override
    public void setId(String id) {
        this.getElement().setId(id);
    }

    @Override
    public String getId() {
        return this.getElement().getId();
    }

    protected Container getContainer() {
        return new Container();
    }

    public void setScrollspy(boolean scrollspy) {
        this.scrollspy = scrollspy;
        if (scrollspy) {
            this.spy = new Scrollspy(this);
        }
    }

    public void setSpyElement(Element spyElement) {
        assert (spyElement != null);
        if (this.spy == null) {
            this.spy = new Scrollspy(this);
        }
        this.spy.setSpyElement(spyElement);
        this.scrollspy = true;
    }

    protected void onAttach() {
        super.onAttach();
        if (this.spy == null) {
            this.spy = new Scrollspy(this);
        }
        if (this.scrollspy) {
            this.spy.configure();
        }
    }

    public void setPosition(NavbarPosition position) {
        for (NavbarPosition p : NavbarPosition.values()) {
            if (p.get().isEmpty()) continue;
            this.removeStyleName(p.get());
        }
        this.addStyle(position);
    }

    public void add(Widget child) {
        this.container.add(child);
    }

    protected void addWidget(Widget widget) {
        super.add(widget);
    }

    public Scrollspy getSpy() {
        return this.spy;
    }

    public void setInverse(boolean inverse) {
        this.setStyleName("navbar-inverse", inverse);
    }

    private class NavbarInner
    extends DivWidget {
        public NavbarInner() {
            this.setStyleName("navbar-inner");
        }
    }
}

