/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Close;
import com.github.gwtbootstrap.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.ModalFooter;
import com.github.gwtbootstrap.client.ui.base.DivWidget;
import com.github.gwtbootstrap.client.ui.base.HasVisibility;
import com.github.gwtbootstrap.client.ui.base.IsAnimated;
import com.github.gwtbootstrap.client.ui.constants.BackdropType;
import com.github.gwtbootstrap.client.ui.constants.DismissType;
import com.github.gwtbootstrap.client.ui.event.HasVisibleHandlers;
import com.github.gwtbootstrap.client.ui.event.HiddenEvent;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.github.gwtbootstrap.client.ui.event.HideEvent;
import com.github.gwtbootstrap.client.ui.event.HideHandler;
import com.github.gwtbootstrap.client.ui.event.ShowEvent;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.github.gwtbootstrap.client.ui.event.ShownEvent;
import com.github.gwtbootstrap.client.ui.event.ShownHandler;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.Set;

public class Modal
extends DivWidget
implements HasVisibility,
HasVisibleHandlers,
IsAnimated {
    private static Set<Modal> currentlyShown = new HashSet<Modal>();
    private final DivWidget header = new DivWidget();
    private final DivWidget body = new DivWidget("modal-body");
    private boolean keyboard = true;
    private BackdropType backdropType = BackdropType.NORMAL;
    private boolean show = false;
    private boolean hideOthers = true;
    private boolean configured = false;
    private Close close = new Close(DismissType.MODAL);
    private String title;

    public Modal() {
        super("modal");
        this.getElement().setAttribute("tabindex", "-1");
        super.add((Widget)this.header);
        super.add((Widget)this.body);
        this.setVisible(false);
    }

    public Modal(boolean animated) {
        this(animated, false);
    }

    public Modal(boolean animated, boolean dynamicSafe) {
        this();
        this.setAnimation(animated);
        this.setDynamicSafe(dynamicSafe);
    }

    public void setDynamicSafe(boolean dynamicSafe) {
        if (dynamicSafe) {
            this.addHiddenHandler(new HiddenHandler(){

                @Override
                public void onHidden(HiddenEvent hiddenEvent) {
                    Modal.this.unsetHandlerFunctions(Modal.this.getElement());
                    Modal.this.removeFromParent();
                }
            });
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.header.clear();
        if (title == null || title.isEmpty()) {
            this.showHeader(false);
        } else {
            this.header.add((Widget)this.close);
            this.header.add((Widget)new Heading(3, title));
            this.showHeader(true);
        }
    }

    public String getTitle() {
        return this.title;
    }

    private void showHeader(boolean show) {
        if (show) {
            this.header.setStyleName("modal-header");
        } else {
            this.header.removeStyleName("modal-header");
        }
    }

    @Override
    public void setAnimation(boolean animated) {
        if (animated) {
            this.addStyleName("fade");
        } else {
            this.removeStyleName("fade");
        }
    }

    @Override
    public boolean getAnimation() {
        return this.getStyleName().contains("fade");
    }

    public void setHideOthers(boolean hideOthers) {
        this.hideOthers = hideOthers;
    }

    public void setKeyboard(boolean keyboard) {
        this.keyboard = keyboard;
        this.reconfigure();
    }

    public boolean isKeyboardEnable() {
        return this.keyboard;
    }

    public void setBackdrop(BackdropType type) {
        this.backdropType = type;
        this.reconfigure();
    }

    public BackdropType getBackdropType() {
        return this.backdropType;
    }

    protected void reconfigure() {
        if (this.configured) {
            this.reconfigure(this.keyboard, this.backdropType, this.show);
        }
    }

    public void add(Widget w) {
        if (w instanceof ModalFooter) {
            super.add(w);
        } else {
            this.body.add(w);
        }
    }

    public void insert(Widget w, int beforeIndex) {
        this.body.insert(w, beforeIndex);
    }

    @Override
    public void show() {
        this.checkAttachedOnShow();
        this.changeVisibility("show");
    }

    public void show(boolean autoShow) {
        this.checkAttachedOnShow();
        this.changeVisibility("show", autoShow);
    }

    private void checkAttachedOnShow() {
        if (!this.isAttached()) {
            RootPanel.get().add((Widget)this);
        }
    }

    protected void onAttach() {
        super.onAttach();
        this.configure(this.keyboard, this.backdropType, this.show);
        this.setHandlerFunctions(this.getElement());
        this.configured = true;
    }

    @Override
    public void hide() {
        this.changeVisibility("hide");
    }

    public void hide(boolean autoHidden) {
        this.changeVisibility("hide", autoHidden);
    }

    @Override
    public void toggle() {
        this.changeVisibility("toggle");
    }

    public void toggle(boolean autoToggle) {
        this.changeVisibility("toggle", autoToggle);
    }

    private void changeVisibility(String visibility) {
        this.changeVisibility(this.getElement(), visibility);
    }

    private void changeVisibility(String visibility, boolean autoTriggered) {
        this.changeVisibility(this.getElement(), visibility, autoTriggered);
    }

    protected void onHide(Event e) {
        this.fireEvent(new HideEvent((NativeEvent)e, this.getAutoTriggered((JavaScriptObject)e)));
    }

    protected void onHidden(Event e) {
        this.fireEvent(new HiddenEvent((NativeEvent)e, this.getAutoTriggered((JavaScriptObject)e)));
        currentlyShown.remove(this);
    }

    protected void onShow(Event e) {
        if (this.hideOthers) {
            this.hideShownModals();
        }
        this.fireEvent(new ShowEvent((NativeEvent)e, this.getAutoTriggered((JavaScriptObject)e)));
    }

    private void hideShownModals() {
        for (Modal m : currentlyShown) {
            if (m.equals(this)) continue;
            m.hide(true);
        }
    }

    protected void onShown(Event e) {
        this.fireEvent(new ShownEvent((NativeEvent)e, this.getAutoTriggered((JavaScriptObject)e)));
        currentlyShown.add(this);
    }

    private void reconfigure(boolean keyboard, BackdropType backdropType, boolean show) {
        if (backdropType == BackdropType.NORMAL) {
            this.reconfigure(this.getElement(), keyboard, true, show);
        } else if (backdropType == BackdropType.NONE) {
            this.reconfigure(this.getElement(), keyboard, false, show);
        } else if (backdropType == BackdropType.STATIC) {
            this.reconfigure(this.getElement(), keyboard, BackdropType.STATIC.get(), show);
        }
    }

    private void configure(boolean keyboard, BackdropType backdropType, boolean show) {
        if (backdropType == BackdropType.NORMAL) {
            this.configure(this.getElement(), keyboard, true, show);
        } else if (backdropType == BackdropType.NONE) {
            this.configure(this.getElement(), keyboard, false, show);
        } else if (backdropType == BackdropType.STATIC) {
            this.configure(this.getElement(), keyboard, BackdropType.STATIC.get(), show);
        }
    }

    private native void reconfigure(Element var1, boolean var2, boolean var3, boolean var4);

    private native void reconfigure(Element var1, boolean var2, String var3, boolean var4);

    private native void configure(Element var1, boolean var2, boolean var3, boolean var4);

    private void configure(Element e, boolean k, String b, boolean s) {
    }

    private void changeVisibility(Element e, String visibility) {
    }

    private native void changeVisibility(Element var1, String var2, boolean var3);

    private native boolean getAutoTriggered(JavaScriptObject var1);

    private void setHandlerFunctions(Element element) {
    }

    private native void unsetHandlerFunctions(Element var1);

    @Override
    public HandlerRegistration addHideHandler(HideHandler handler) {
        return this.addHandler(handler, HideEvent.getType());
    }

    @Override
    public HandlerRegistration addHiddenHandler(HiddenHandler handler) {
        return this.addHandler(handler, HiddenEvent.getType());
    }

    @Override
    public HandlerRegistration addShowHandler(ShowHandler handler) {
        return this.addHandler(handler, ShowEvent.getType());
    }

    @Override
    public HandlerRegistration addShownHandler(ShownHandler handler) {
        return this.addHandler(handler, ShownEvent.getType());
    }

    public void setCloseVisible(boolean visible) {
        this.close.getElement().getStyle().setVisibility(visible ? Style.Visibility.VISIBLE : Style.Visibility.HIDDEN);
    }

    @Deprecated
    public void setSize(String width, String height) {
        throw new UnsupportedOperationException("modal do not support setSize method");
    }

    public void setWidth(int width) {
        DOM.setStyleAttribute((Element)this.getElement(), (String)"width", (String)(width + "px"));
        DOM.setStyleAttribute((Element)this.getElement(), (String)"marginLeft", (String)(-width / 2 + "px"));
    }

    public void setMaxHeigth(String maxHeight) {
        DOM.setStyleAttribute((Element)this.body.getElement(), (String)"maxHeight", (String)maxHeight);
    }
}

