/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.ComplexWidget;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.FormType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.FormElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.impl.FormPanelImpl;
import com.google.gwt.user.client.ui.impl.FormPanelImplHost;

public class Form
extends ComplexWidget
implements FormPanelImplHost {
    private static FormPanelImpl impl = (FormPanelImpl)GWT.create(FormPanelImpl.class);
    private static int formId = 0;
    private String frameName;
    private Element synthesizedFrame;

    public Form() {
        this(true);
    }

    public Form(boolean createIFrame) {
        this((Element)Document.get().createFormElement(), createIFrame);
    }

    public HandlerRegistration addSubmitCompleteHandler(SubmitCompleteHandler handler) {
        return this.addHandler(handler, SubmitCompleteEvent.getType());
    }

    public HandlerRegistration addSubmitHandler(SubmitHandler handler) {
        return this.addHandler(handler, SubmitEvent.getType());
    }

    public String getAction() {
        return this.getFormElement().getAction();
    }

    public String getEncoding() {
        return impl.getEncoding(this.getElement());
    }

    public String getMethod() {
        return this.getFormElement().getMethod();
    }

    protected Form(Element element, boolean createIFrame) {
        super(element.getTagName());
        FormElement.as((Element)element);
        if (createIFrame) {
            assert (this.getTarget() == null || this.getTarget().trim().length() == 0) : "Cannot create target iframe if the form's target is already set.";
            this.frameName = "BSFormPanel_" + GWT.getModuleName() + "_" + ++formId;
            this.setTarget(this.frameName);
            this.sinkEvents(32768);
        }
    }

    public String getTarget() {
        return this.getFormElement().getTarget();
    }

    private FormElement getFormElement() {
        return (FormElement)this.getElement().cast();
    }

    public void setType(FormType type) {
        StyleHelper.changeStyle((UIObject)this, type, FormType.class);
    }

    public void reset() {
        impl.reset(this.getElement());
    }

    public void setAction(String url) {
        this.getFormElement().setAction(url);
    }

    public void setAction(SafeUri url) {
        this.setAction(url.asString());
    }

    public void setEncoding(String encodingType) {
        impl.setEncoding(this.getElement(), encodingType);
    }

    public void setMethod(String method) {
        this.getFormElement().setMethod(method);
    }

    public void submit() {
        if (!this.fireSubmitEvent()) {
            return;
        }
        impl.submit(this.getElement(), this.synthesizedFrame);
    }

    protected void onAttach() {
        super.onAttach();
        if (this.frameName != null) {
            this.createFrame();
            Document.get().getBody().appendChild((Node)this.synthesizedFrame);
        }
        impl.hookEvents(this.synthesizedFrame, this.getElement(), (FormPanelImplHost)this);
    }

    protected void onDetach() {
        super.onDetach();
        impl.unhookEvents(this.synthesizedFrame, this.getElement());
        if (this.synthesizedFrame != null) {
            Document.get().getBody().removeChild((Node)this.synthesizedFrame);
            this.synthesizedFrame = null;
        }
    }

    private void createFrame() {
        this.synthesizedFrame = Document.get().createIFrameElement();
        this.synthesizedFrame.setAttribute("name", this.frameName);
    }

    private boolean fireSubmitEvent() {
        SubmitEvent event = new SubmitEvent();
        this.fireEvent(event);
        return !event.isCanceled();
    }

    private boolean onFormSubmitImpl() {
        return this.fireSubmitEvent();
    }

    private void onFrameLoadImpl() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Form.this.fireEvent(new SubmitCompleteEvent(impl.getContents(Form.this.synthesizedFrame)));
            }
        });
    }

    public void setTarget(String target) {
        this.getFormElement().setTarget(target);
    }

    public boolean onFormSubmit() {
        return this.onFormSubmitImpl();
    }

    public void onFrameLoad() {
        this.onFrameLoadImpl();
    }

    public static interface SubmitHandler
    extends EventHandler {
        public void onSubmit(SubmitEvent var1);
    }

    public static class SubmitEvent
    extends GwtEvent<SubmitHandler> {
        private static GwtEvent.Type<SubmitHandler> TYPE = new GwtEvent.Type();
        private boolean canceled = false;

        static GwtEvent.Type<SubmitHandler> getType() {
            if (TYPE == null) {
                TYPE = new GwtEvent.Type();
            }
            return TYPE;
        }

        public void cancel() {
            this.canceled = true;
        }

        public final GwtEvent.Type<SubmitHandler> getAssociatedType() {
            return TYPE;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        protected void dispatch(SubmitHandler handler) {
            handler.onSubmit(this);
        }
    }

    public static interface SubmitCompleteHandler
    extends EventHandler {
        public void onSubmitComplete(SubmitCompleteEvent var1);
    }

    public static class SubmitCompleteEvent
    extends GwtEvent<SubmitCompleteHandler> {
        private static GwtEvent.Type<SubmitCompleteHandler> TYPE;
        private String resultHtml;

        static GwtEvent.Type<SubmitCompleteHandler> getType() {
            if (TYPE == null) {
                TYPE = new GwtEvent.Type();
            }
            return TYPE;
        }

        protected SubmitCompleteEvent(String resultsHtml) {
            this.resultHtml = resultsHtml;
        }

        public final GwtEvent.Type<SubmitCompleteHandler> getAssociatedType() {
            return TYPE;
        }

        public String getResults() {
            return this.resultHtml;
        }

        protected void dispatch(SubmitCompleteHandler handler) {
            handler.onSubmitComplete(this);
        }
    }
}

