/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Dropdown;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.base.UnorderedList;
import com.github.gwtbootstrap.client.ui.event.HideEvent;
import com.github.gwtbootstrap.client.ui.event.HideHandler;
import com.github.gwtbootstrap.client.ui.event.ShowEvent;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Widget;

public class DropdownContainer
extends Dropdown {
    private UnorderedList menu = new UnorderedList();
    private boolean menuVisible;
    private HandlerManager handlerManager;

    @Override
    protected IconAnchor createTrigger() {
        IconAnchor trigger = super.createTrigger();
        trigger.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (DropdownContainer.this.menuVisible) {
                    DropdownContainer.this.hideContainer();
                } else {
                    DropdownContainer.this.showContainer();
                }
            }
        }, ClickEvent.getType());
        return trigger;
    }

    public DropdownContainer() {
        this("");
    }

    public DropdownContainer(String caption) {
        super(caption);
        for (Widget widget : this.getChildren()) {
            if (!(widget instanceof UnorderedList)) continue;
            this.menu = (UnorderedList)widget;
            break;
        }
        this.menu.getElement().getStyle().clearDisplay();
        this.menu.getElement().getStyle().setDisplay(Style.Display.NONE);
        this.handlerManager = this.createHandlerManager();
    }

    public void showContainer() {
        this.menu.getElement().getStyle().setDisplay(Style.Display.BLOCK);
        this.menuVisible = true;
        for (int i = 0; i < this.handlerManager.getHandlerCount(ShowEvent.getType()); ++i) {
            ShowHandler sh = (ShowHandler)this.handlerManager.getHandler(ShowEvent.getType(), i);
            sh.onShow(new ShowEvent(null));
        }
    }

    public void hideContainer() {
        this.menu.getElement().getStyle().setDisplay(Style.Display.NONE);
        this.menuVisible = false;
        for (int i = 0; i < this.handlerManager.getHandlerCount(HideEvent.getType()); ++i) {
            HideHandler hh = (HideHandler)this.handlerManager.getHandler(HideEvent.getType(), i);
            hh.onHide(new HideEvent(null));
        }
    }

    public HandlerRegistration addHideHandler(HideHandler hideHandler) {
        return this.handlerManager.addHandler(HideEvent.getType(), (EventHandler)hideHandler);
    }

    public HandlerRegistration addShowHandler(ShowHandler showHandler) {
        return this.handlerManager.addHandler(ShowEvent.getType(), (EventHandler)showHandler);
    }
}

