/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.DropdownButton;
import com.github.gwtbootstrap.client.ui.base.DivWidget;
import com.github.gwtbootstrap.client.ui.base.DropdownBase;
import com.github.gwtbootstrap.client.ui.base.MarkupWidget;
import com.github.gwtbootstrap.client.ui.constants.ToggleType;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;

public class ButtonGroup
extends DivWidget {
    public ButtonGroup() {
        this.setStyleName("btn-group");
    }

    public ButtonGroup(Button ... buttons) {
        this();
        for (Button btn : buttons) {
            this.add((Widget)btn);
        }
    }

    public void add(IsWidget child) {
        Widget widget = ButtonGroup.asWidgetOrNull((IsWidget)child);
        if (child instanceof MarkupWidget && widget instanceof DropdownButton) {
            MarkupWidget markup = (MarkupWidget)child;
            DropdownButton dropdownBase = (DropdownButton)widget;
            markup.setWidget((Widget)dropdownBase.getTriggerWidget());
            markup.asWidget();
        }
        this.add(widget);
    }

    public void add(Widget widget) {
        if (widget instanceof Button) {
            super.add(widget);
            return;
        }
        if (widget instanceof DropdownButton) {
            this.add((DropdownButton)widget);
            return;
        }
        throw new IllegalArgumentException("A ButtonGroup can only contain Buttons or DropdownButton. You added " + widget);
    }

    private void add(DropdownBase dropdown) {
        super.add((Widget)dropdown.getTriggerWidget());
        super.add((Widget)dropdown.getMenuWiget());
        this.setStyleName("dropup", dropdown.isDropup());
    }

    public boolean remove(Widget w) {
        if (!(w instanceof DropdownBase)) {
            return super.remove(w);
        }
        DropdownBase dropdown = (DropdownBase)w;
        super.remove((Widget)dropdown.getTriggerWidget());
        return super.remove((Widget)dropdown.getMenuWiget());
    }

    public void setToggle(ToggleType type) {
        if (type == null || type == ToggleType.NONE) {
            this.getElement().removeAttribute("data-toggle");
            return;
        }
        this.getElement().setAttribute("data-toggle", type.get());
    }

    public void setToggle(String toggle) {
        try {
            this.setToggle(ToggleType.valueOf(toggle.toUpperCase()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid toggle option.");
        }
    }

    public void setVertical(boolean vertical) {
        this.setStyleName("btn-group-vertical", vertical);
    }
}

