/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.base.HasType;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.base.StyleHelper;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.DismissType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.DragEndEvent;
import com.google.gwt.event.dom.client.DragEndHandler;
import com.google.gwt.event.dom.client.DragEnterEvent;
import com.google.gwt.event.dom.client.DragEnterHandler;
import com.google.gwt.event.dom.client.DragEvent;
import com.google.gwt.event.dom.client.DragHandler;
import com.google.gwt.event.dom.client.DragLeaveEvent;
import com.google.gwt.event.dom.client.DragLeaveHandler;
import com.google.gwt.event.dom.client.DragOverEvent;
import com.google.gwt.event.dom.client.DragOverHandler;
import com.google.gwt.event.dom.client.DragStartEvent;
import com.google.gwt.event.dom.client.DragStartHandler;
import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.event.dom.client.DropHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.GestureChangeEvent;
import com.google.gwt.event.dom.client.GestureChangeHandler;
import com.google.gwt.event.dom.client.GestureEndEvent;
import com.google.gwt.event.dom.client.GestureEndHandler;
import com.google.gwt.event.dom.client.GestureStartEvent;
import com.google.gwt.event.dom.client.GestureStartHandler;
import com.google.gwt.event.dom.client.HasAllDragAndDropHandlers;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.dom.client.HasAllGestureHandlers;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.HasAllTouchHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasDoubleClickHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.dom.client.TouchCancelEvent;
import com.google.gwt.event.dom.client.TouchCancelHandler;
import com.google.gwt.event.dom.client.TouchEndEvent;
import com.google.gwt.event.dom.client.TouchEndHandler;
import com.google.gwt.event.dom.client.TouchMoveEvent;
import com.google.gwt.event.dom.client.TouchMoveHandler;
import com.google.gwt.event.dom.client.TouchStartEvent;
import com.google.gwt.event.dom.client.TouchStartHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.UIObject;

public class Button
extends IconAnchor
implements HasClickHandlers,
HasDoubleClickHandlers,
HasEnabled,
HasType<ButtonType>,
HasAllDragAndDropHandlers,
HasAllFocusHandlers,
HasAllGestureHandlers,
HasAllKeyHandlers,
HasAllMouseHandlers,
HasAllTouchHandlers {
    private final LoadingStateBehavior state = new LoadingStateBehavior();
    private ButtonType type;
    private ButtonSize size;

    public Button() {
        this.addStyleName("btn");
    }

    public Button(ClickHandler handler) {
        this();
        this.addClickHandler(handler);
    }

    public Button(String caption) {
        this();
        this.setText(caption);
    }

    public Button(String caption, ClickHandler handler) {
        this(caption);
        this.addClickHandler(handler);
    }

    public Button(String caption, IconType icon) {
        this(caption);
        this.setIcon(icon);
    }

    public Button(String caption, IconType icon, ClickHandler handler) {
        this(caption, icon);
        this.addClickHandler(handler);
    }

    @Override
    public void setType(ButtonType type) {
        this.type = type;
        StyleHelper.changeStyle((UIObject)this, type, ButtonType.class);
    }

    public void setSize(ButtonSize size) {
        this.size = size;
        StyleHelper.changeStyle((UIObject)this, size, ButtonSize.class);
    }

    @Override
    public boolean isEnabled() {
        return !this.getStyleName().contains("disabled");
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.removeStyleName("disabled");
        } else {
            this.addStyleName("disabled");
        }
    }

    public void setToggle(boolean toggle) {
        if (toggle) {
            this.getElement().setAttribute("data-toggle", "button");
        } else {
            this.getElement().removeAttribute("data-toggle");
        }
    }

    public boolean isToggle() {
        return this.getElement().getAttribute("data-toggle").equals("button");
    }

    public boolean isToggled() {
        return this.getStyleName().toLowerCase().contains("active");
    }

    public void setLoadingText(String text) {
        if (text == null || text.trim().isEmpty()) {
            this.getElement().removeAttribute("data-loading-text");
            return;
        }
        this.getElement().setAttribute("data-loading-text", text);
    }

    public void setCompleteText(String text) {
        if (text == null || text.trim().isEmpty()) {
            this.getElement().removeAttribute("data-complete-text");
            return;
        }
        this.getElement().setAttribute("data-complete-text", text);
    }

    public LoadingStateBehavior state() {
        return this.state;
    }

    @Override
    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
    }

    public HandlerRegistration addDoubleClickHandler(DoubleClickHandler handler) {
        return this.addDomHandler((EventHandler)handler, DoubleClickEvent.getType());
    }

    public HandlerRegistration addDragEndHandler(DragEndHandler handler) {
        return this.addDomHandler((EventHandler)handler, DragEndEvent.getType());
    }

    public HandlerRegistration addDragEnterHandler(DragEnterHandler handler) {
        return this.addDomHandler((EventHandler)handler, DragEnterEvent.getType());
    }

    public HandlerRegistration addDragLeaveHandler(DragLeaveHandler handler) {
        return this.addDomHandler((EventHandler)handler, DragLeaveEvent.getType());
    }

    public HandlerRegistration addDragHandler(DragHandler handler) {
        return this.addDomHandler((EventHandler)handler, DragEvent.getType());
    }

    public HandlerRegistration addDragOverHandler(DragOverHandler handler) {
        return this.addDomHandler((EventHandler)handler, DragOverEvent.getType());
    }

    public HandlerRegistration addDragStartHandler(DragStartHandler handler) {
        return this.addDomHandler((EventHandler)handler, DragStartEvent.getType());
    }

    public HandlerRegistration addDropHandler(DropHandler handler) {
        return this.addDomHandler((EventHandler)handler, DropEvent.getType());
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.addDomHandler((EventHandler)handler, FocusEvent.getType());
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.addDomHandler((EventHandler)handler, BlurEvent.getType());
    }

    public HandlerRegistration addGestureStartHandler(GestureStartHandler handler) {
        return this.addDomHandler((EventHandler)handler, GestureStartEvent.getType());
    }

    public HandlerRegistration addGestureChangeHandler(GestureChangeHandler handler) {
        return this.addDomHandler((EventHandler)handler, GestureChangeEvent.getType());
    }

    public HandlerRegistration addGestureEndHandler(GestureEndHandler handler) {
        return this.addDomHandler((EventHandler)handler, GestureEndEvent.getType());
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.addDomHandler((EventHandler)handler, KeyUpEvent.getType());
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.addDomHandler((EventHandler)handler, KeyDownEvent.getType());
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.addDomHandler((EventHandler)handler, KeyPressEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseDownEvent.getType());
    }

    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseUpEvent.getType());
    }

    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOutEvent.getType());
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOverEvent.getType());
    }

    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseMoveEvent.getType());
    }

    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseWheelEvent.getType());
    }

    public HandlerRegistration addTouchStartHandler(TouchStartHandler handler) {
        return this.addDomHandler((EventHandler)handler, TouchStartEvent.getType());
    }

    public HandlerRegistration addTouchMoveHandler(TouchMoveHandler handler) {
        return this.addDomHandler((EventHandler)handler, TouchMoveEvent.getType());
    }

    public HandlerRegistration addTouchEndHandler(TouchEndHandler handler) {
        return this.addDomHandler((EventHandler)handler, TouchEndEvent.getType());
    }

    public HandlerRegistration addTouchCancelHandler(TouchCancelHandler handler) {
        return this.addDomHandler((EventHandler)handler, TouchCancelEvent.getType());
    }

    public ButtonType getType() {
        return this.type;
    }

    public ButtonSize getSize() {
        return this.size;
    }

    public void setBlock(boolean block) {
        this.setStyleName("btn-block", block);
    }

    public void click() {
        NativeEvent event = Document.get().createClickEvent(0, 0, 0, 0, 0, false, false, false, false);
        DomEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this);
    }

    public void setDismiss(DismissType type) {
        this.getElement().setAttribute("data-dismiss", type.get());
    }

    public class LoadingStateBehavior {
        public void loading() {
            this.setLoadingBehavior("loading");
        }

        public void reset() {
            this.setLoadingBehavior("reset");
        }

        public void complete() {
            this.setLoadingBehavior("complete");
        }

        private void setLoadingBehavior(String behavior) {
            Button.this.icon.removeFromParent();
            this.setLoadingBehavior(Button.this.getElement(), behavior);
            Button.this.icon = new Icon(Button.this.icon.getIconType());
            Button.this.setText(Button.this.getElement().getInnerText());
        }

        private native void setLoadingBehavior(Element var1, String var2);
    }
}

