/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.base.AbstractTypography;
import com.github.gwtbootstrap.client.ui.constants.Alignment;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.DOM;

public class Blockquote
extends AbstractTypography {
    public Blockquote() {
        this.setElement(DOM.createElement((String)"blockquote"));
    }

    public Blockquote(String text) {
        this.setText(text);
    }

    public Blockquote(String text, String source) {
        this(text);
        this.setSource(source);
    }

    public Blockquote(String text, boolean pullRight) {
        this.setText(text);
        this.setPullRight(pullRight);
    }

    public Blockquote(String text, String source, boolean pullRight) {
        this(text);
        this.setSource(source);
        this.setPullRight(pullRight);
    }

    public void setSource(String source) {
        this.getElement().appendChild((Node)new SmallCite(source).getElement());
    }

    public void setPullRight(boolean pullright) {
        if (pullright) {
            this.setStyle(Alignment.RIGHT);
        } else {
            this.setStyle(Alignment.NONE);
        }
    }

    private class SmallCite
    extends AbstractTypography {
        private final Cite cite;

        public SmallCite(String text) {
            this.setElement(DOM.createElement((String)"small"));
            this.cite = new Cite(text);
            this.getElement().appendChild((Node)this.cite.getElement());
        }

        @Override
        public void setText(String text) {
            this.cite.setText(text);
        }
    }

    private class Cite
    extends AbstractTypography {
        public Cite(String text) {
            this.setElement(DOM.createElement((String)"cite"));
            this.setText(text);
        }
    }
}

