/*
 * Decompiled with CFR 0.152.
 */
package com.github.gwtbootstrap.client.ui;

import com.github.gwtbootstrap.client.ui.Collapse;
import com.github.gwtbootstrap.client.ui.CollapseTrigger;
import com.github.gwtbootstrap.client.ui.base.DivWidget;
import com.github.gwtbootstrap.client.ui.base.HasIcon;
import com.github.gwtbootstrap.client.ui.base.HasVisibility;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.BaseIconType;
import com.github.gwtbootstrap.client.ui.constants.IconPosition;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.event.HasVisibleHandlers;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.github.gwtbootstrap.client.ui.event.HideHandler;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.github.gwtbootstrap.client.ui.event.ShownHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.client.ui.Widget;

public class AccordionGroup
extends DivWidget
implements HasIcon,
HasVisibility,
HasVisibleHandlers {
    private final DivWidget heading;
    private DivWidget innerBody = new DivWidget("accordion-inner");
    private IconAnchor trigger = new IconAnchor();
    private Collapse collapse;
    private CollapseTrigger collapseTrigger;
    private boolean defaultOpen;

    public AccordionGroup() {
        super("accordion-group");
        DivWidget body = new DivWidget("accordion-body");
        body.add((Widget)this.innerBody);
        this.collapse = new Collapse();
        this.collapse.setWidget((Widget)body);
        this.collapse.setExistTrigger(true);
        this.trigger.addStyleName("accordion-toggle");
        this.collapseTrigger = new CollapseTrigger("#" + this.collapse.getId());
        this.collapseTrigger.setAccordionTrigger(true);
        this.collapseTrigger.setWidget((Widget)this.trigger);
        this.heading = new DivWidget("accordion-heading");
        this.heading.add(this.collapseTrigger);
        super.add((Widget)this.heading);
        super.add(this.collapse.asWidget());
    }

    public DivWidget getHeading() {
        return this.heading;
    }

    public IconAnchor getTrigger() {
        return this.trigger;
    }

    @Override
    public void setIcon(IconType type) {
        this.setBaseIcon(type);
    }

    @Override
    public void setBaseIcon(BaseIconType type) {
        this.trigger.setBaseIcon(type);
    }

    @Override
    public void setIconSize(IconSize size) {
        this.trigger.setIconSize(size);
    }

    public void setParent(String parent) {
        this.collapseTrigger.setParent(parent);
    }

    @Override
    public HandlerRegistration addHideHandler(HideHandler handler) {
        return this.collapse.addHideHandler(handler);
    }

    @Override
    public HandlerRegistration addHiddenHandler(HiddenHandler handler) {
        return this.collapse.addHiddenHandler(handler);
    }

    @Override
    public HandlerRegistration addShowHandler(ShowHandler handler) {
        return this.collapse.addShowHandler(handler);
    }

    @Override
    public HandlerRegistration addShownHandler(ShownHandler handler) {
        return this.collapse.addShownHandler(handler);
    }

    @Override
    public void show() {
        this.collapse.show();
    }

    @Override
    public void hide() {
        this.collapse.hide();
    }

    @Override
    public void toggle() {
        this.collapse.toggle();
    }

    public void add(Widget w) {
        this.innerBody.add(w);
    }

    public void clear() {
        this.innerBody.clear();
    }

    public boolean remove(Widget w) {
        return this.innerBody.remove(w);
    }

    @UiChild(limit=1, tagname="customTrigger")
    public void addCustomTrigger(Widget w) {
        this.trigger.insert(w, 0);
    }

    public boolean isDefaultOpen() {
        return this.defaultOpen;
    }

    public void setDefaultOpen(boolean defaultOpen) {
        this.defaultOpen = defaultOpen;
        if (!this.isAttached()) {
            this.collapse.getWidget().setStyleName("in", defaultOpen);
        }
    }

    public void setHeading(String heading) {
        this.trigger.setText(heading);
    }

    @Override
    public void setCustomIconStyle(String customIconStyle) {
        this.trigger.setCustomIconStyle(customIconStyle);
    }

    @Override
    public void setIconPosition(IconPosition position) {
        this.trigger.setIconPosition(position);
    }
}

