/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.util;

import android.os.Build;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.widget.EditText;
import android.widget.TextView;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

public final class StringUtil {
    private static final String CSV_DELIMITER = ",";

    @NonNull
    public static String listToCsv(@NonNull List<String> list) {
        return TextUtils.join((CharSequence)CSV_DELIMITER, list);
    }

    @NonNull
    public static List<String> csvToList(@NonNull String csv) {
        return StringUtil.delimiterStringToList(csv, CSV_DELIMITER);
    }

    @NonNull
    public static List<String> delimiterStringToList(@NonNull String delimitedString, @NonNull String delimiter) {
        return Arrays.asList(TextUtils.split((String)delimitedString, (String)delimiter));
    }

    @NonNull
    public static String md5string(@NonNull String s) {
        StringBuilder hexStr = new StringBuilder();
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes("utf-8"));
            byte[] messageDigest = digest.digest();
            int maxByteVal = 255;
            for (byte b : messageDigest) {
                hexStr.append(Integer.toHexString(0xFF & b));
            }
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return hexStr.toString();
    }

    @NonNull
    public static CharSequence strip(@Nullable CharSequence str) {
        int start;
        if (str == null || str.length() == 0) {
            return "";
        }
        int len = str.length();
        int end = len - 1;
        for (start = 0; start < len && Character.isWhitespace(str.charAt(start)); ++start) {
        }
        while (end > 0 && Character.isWhitespace(str.charAt(end))) {
            --end;
        }
        if (end > start) {
            return str.subSequence(start, end + 1);
        }
        return "";
    }

    @NonNull
    public static String intToHexStr(int i) {
        return String.format("x%08x", i);
    }

    public static String addUnderscores(@NonNull String text) {
        return text.replace(" ", "_");
    }

    public static String removeUnderscores(@NonNull String text) {
        return text.replace("_", " ");
    }

    public static boolean hasSectionAnchor(@NonNull String text) {
        return text.contains("#");
    }

    public static String removeSectionAnchor(String text) {
        return text.substring(0, text.indexOf("#"));
    }

    public static String removeNamespace(@NonNull String text) {
        if (text.length() > text.indexOf(":")) {
            return text.substring(text.indexOf(":") + 1, text.length());
        }
        return text;
    }

    public static String removeHTMLTags(@NonNull String text) {
        return StringUtil.fromHtml(text).toString();
    }

    public static String sanitizeText(@NonNull String selectedText) {
        return selectedText.replaceAll("\\[\\d+\\]", "").replaceAll("\\s*/[^/]+/;?\\s*", "").replaceAll("\\(\\s*;\\s*", "\\(").replaceAll("\\s{2,}", " ").trim();
    }

    public static boolean normalizedEquals(@Nullable String str1, @Nullable String str2) {
        if (str1 == null || str2 == null) {
            return str1 == null && str2 == null;
        }
        return Normalizer.normalize(str1, Normalizer.Form.NFC).equals(Normalizer.normalize(str2, Normalizer.Form.NFC));
    }

    @NonNull
    public static Spanned fromHtml(@Nullable String source) {
        if (source == null) {
            return new SpannedString((CharSequence)"");
        }
        if (!source.contains("<") && !source.contains("&")) {
            return new SpannedString((CharSequence)source);
        }
        source = source.replaceAll("&#8206;", "\u200e").replaceAll("&#8207;", "\u200f").replaceAll("&amp;", "&");
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)source, (int)0);
        }
        return Html.fromHtml((String)source);
    }

    @NonNull
    public static SpannableStringBuilder boldenSubstrings(@NonNull String text, @NonNull List<String> subStrings) {
        SpannableStringBuilder sb = new SpannableStringBuilder((CharSequence)text);
        for (String subString : subStrings) {
            int index = text.toLowerCase().indexOf(subString.toLowerCase());
            if (index == -1) continue;
            sb.setSpan(Build.VERSION.SDK_INT >= 21 ? new TypefaceSpan("sans-serif-medium") : new StyleSpan(1), index, index + subString.length(), 18);
        }
        return sb;
    }

    public static void highlightEditText(@NonNull EditText editText, @NonNull String parentText, @NonNull String highlightText) {
        String word;
        String[] words = highlightText.split("\\s+");
        int pos = 0;
        String[] stringArray = words;
        int n = stringArray.length;
        for (int i = 0; i < n && (pos = parentText.indexOf(word = stringArray[i], pos)) != -1; ++i) {
        }
        if (pos == -1) {
            pos = parentText.indexOf(words[words.length - 1]);
        }
        if (pos >= 0) {
            editText.setSelection(pos, pos + words[words.length - 1].length());
            editText.performLongClick();
        }
    }

    public static void boldenKeywordText(@NonNull TextView textView, @NonNull String parentText, @Nullable String searchQuery) {
        int startIndex = StringUtil.indexOf(parentText, searchQuery);
        if (startIndex >= 0) {
            parentText = parentText.substring(0, startIndex) + "<strong>" + parentText.substring(startIndex, startIndex + searchQuery.length()) + "</strong>" + parentText.substring(startIndex + searchQuery.length());
            textView.setText((CharSequence)StringUtil.fromHtml(parentText));
        } else {
            textView.setText((CharSequence)parentText);
        }
    }

    private static int indexOf(@NonNull String original, @Nullable String search) {
        if (!TextUtils.isEmpty((CharSequence)search)) {
            Collator collator = Collator.getInstance();
            collator.setStrength(0);
            for (int i = 0; i <= original.length() - search.length(); ++i) {
                if (!collator.equals(search, original.substring(i, i + search.length()))) continue;
                return i;
            }
        }
        return -1;
    }

    @NonNull
    public static String getBase26String(@IntRange(from=1L) int number) {
        int base = 26;
        String str = "";
        while (--number >= 0) {
            str = (char)(65 + number % 26) + str;
            number /= 26;
        }
        return str;
    }

    @NonNull
    public static String listToJsonArrayString(@NonNull List<String> list) {
        return new JSONArray(list).toString();
    }

    public static String stringToListMapToJSONString(@Nullable Map<String, List<Integer>> map) {
        return new Gson().toJson(map);
    }

    public static String listToJSONString(@Nullable List<Integer> list) {
        return new Gson().toJson(list);
    }

    private StringUtil() {
    }
}

